/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import javax.naming.NamingException;
import org.jboss.as.naming.InitialContextFactory;
import org.jboss.as.naming.NamingMessages;
import org.wildfly.security.manager.WildFlySecurityManager;

public class InitialContextFactoryBuilder
implements javax.naming.spi.InitialContextFactoryBuilder {
    private static final javax.naming.spi.InitialContextFactory DEFAULT_FACTORY = new InitialContextFactory();

    @Override
    public javax.naming.spi.InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        String factoryClassName;
        if (environment == null) {
            environment = new Hashtable();
        }
        if ((factoryClassName = (String)environment.get("java.naming.factory.initial")) == null || InitialContextFactory.class.getName().equals(factoryClassName)) {
            return DEFAULT_FACTORY;
        }
        ClassLoader classLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            Class<?> factoryClass = Class.forName(factoryClassName, true, classLoader);
            return (javax.naming.spi.InitialContextFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw NamingMessages.MESSAGES.failedToInstantiate("InitialContextFactory", factoryClassName, classLoader);
        }
    }
}

