/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.publish;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.deployers.EndpointServiceDeploymentAspect;
import org.jboss.as.webservices.deployers.deployment.DeploymentAspectsProvider;
import org.jboss.as.webservices.deployers.deployment.WSDeploymentBuilder;
import org.jboss.as.webservices.publish.WSEndpointDeploymentUnit;
import org.jboss.as.webservices.service.ServerConfigService;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.ws.common.deployment.DeploymentAspectManagerImpl;
import org.jboss.ws.common.invocation.InvocationHandlerJAXWS;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointState;
import org.jboss.wsf.spi.deployment.WSFServlet;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;
import org.jboss.wsf.spi.publish.EndpointPublisher;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class EndpointPublisherImpl
implements EndpointPublisher {
    private WebHost host;
    private boolean runningInService = false;
    private static List<DeploymentAspect> depAspects = null;

    public EndpointPublisherImpl(WebHost host) {
        this.host = host;
    }

    public EndpointPublisherImpl(WebHost host, boolean runningInService) {
        this(host);
        this.runningInService = runningInService;
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap) throws Exception {
        return this.publish(EndpointPublisherImpl.getBaseTarget(), context, loader, urlPatternToClassNameMap, null, null, null);
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData metadata) throws Exception {
        return this.publish(EndpointPublisherImpl.getBaseTarget(), context, loader, urlPatternToClassNameMap, null, metadata, null);
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData metadata, JBossWebservicesMetaData jbwsMetadata) throws Exception {
        return this.publish(EndpointPublisherImpl.getBaseTarget(), context, loader, urlPatternToClassNameMap, null, metadata, jbwsMetadata);
    }

    public Context publish(ServiceTarget target, String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, JBossWebMetaData jbwmd, WebservicesMetaData metadata, JBossWebservicesMetaData jbwsMetadata) throws Exception {
        WSEndpointDeploymentUnit unit = new WSEndpointDeploymentUnit(loader, context, urlPatternToClassNameMap, jbwmd, metadata, jbwsMetadata);
        return new Context(context, this.publish(target, unit));
    }

    private static ServiceTarget getBaseTarget() {
        return WSServices.getContainerRegistry().getService(WSServices.CONFIG_SERVICE).getServiceContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> publish(ServiceTarget target, WSEndpointDeploymentUnit unit) throws Exception {
        List<DeploymentAspect> aspects = this.getDeploymentAspects();
        ClassLoader origClassLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        Deployment dep = null;
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            WSDeploymentBuilder.getInstance().build(unit);
            dep = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
            dep.addAttachment(ServiceTarget.class, (Object)target);
            DeploymentAspectManagerImpl dam = new DeploymentAspectManagerImpl();
            dam.setDeploymentAspects(aspects);
            dam.deploy(dep);
            for (Endpoint ep : dep.getService().getEndpoints()) {
                ep.setState(EndpointState.STOPPED);
                ep.setInvocationHandler((InvocationHandler)new InvocationHandlerJAXWS());
                ep.setState(EndpointState.STARTED);
            }
        }
        finally {
            if (dep != null) {
                dep.removeAttachment(ServiceTarget.class);
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origClassLoader);
        }
        Deployment deployment = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
        deployment.addAttachment(WebDeploymentController.class, (Object)EndpointPublisherImpl.startWebApp(this.host, unit));
        return deployment.getService().getEndpoints();
    }

    private static WebDeploymentController startWebApp(WebHost host, WSEndpointDeploymentUnit unit) throws Exception {
        WebDeploymentController handle;
        WebDeploymentBuilder deployment = new WebDeploymentBuilder();
        try {
            JBossWebMetaData jbwebMD = (JBossWebMetaData)unit.getAttachment(WSAttachmentKeys.JBOSSWEB_METADATA_KEY);
            deployment.setContextRoot(jbwebMD.getContextRoot());
            ServerConfigService config = (ServerConfigService)unit.getServiceRegistry().getService(WSServices.CONFIG_SERVICE).getService();
            File docBase = new File(config.getValue().getServerTempDir(), jbwebMD.getContextRoot());
            if (!docBase.exists()) {
                docBase.mkdirs();
            }
            deployment.setDocumentRoot(docBase);
            deployment.setClassLoader((ClassLoader)unit.getAttachment(WSAttachmentKeys.CLASSLOADER_KEY));
            EndpointPublisherImpl.addServlets(jbwebMD, deployment);
            handle = host.addWebDeployment(deployment);
            handle.create();
        }
        catch (Exception e) {
            throw WSMessages.MESSAGES.createContextPhaseFailed(e);
        }
        try {
            handle.start();
        }
        catch (Exception e) {
            throw WSMessages.MESSAGES.startContextPhaseFailed(e);
        }
        return handle;
    }

    private static void addServlets(JBossWebMetaData jbwebMD, WebDeploymentBuilder deployment) {
        for (JBossServletMetaData smd : jbwebMD.getServlets()) {
            String sc = smd.getServletClass();
            if (!sc.equals(WSFServlet.class.getName())) continue;
            ServletBuilder servletBuilder = new ServletBuilder();
            String servletName = smd.getServletName();
            List params = smd.getInitParam();
            List urlPatterns = null;
            for (ServletMappingMetaData smmd : jbwebMD.getServletMappings()) {
                if (!smmd.getServletName().equals(servletName)) continue;
                urlPatterns = smmd.getUrlPatterns();
                servletBuilder.addUrlMappings((Collection)urlPatterns);
                break;
            }
            WSFServlet wsfs = new WSFServlet();
            servletBuilder.setServletName(servletName);
            servletBuilder.setServlet((Servlet)wsfs);
            servletBuilder.setServletClass(WSFServlet.class);
            for (ParamValueMetaData param : params) {
                servletBuilder.addInitParam(param.getParamName(), param.getParamValue());
            }
            deployment.addServlet(servletBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Context context) throws Exception {
        List eps = context.getEndpoints();
        if (eps == null || eps.isEmpty()) {
            return;
        }
        Deployment deployment = ((Endpoint)eps.get(0)).getService().getDeployment();
        List<DeploymentAspect> aspects = this.getDeploymentAspects();
        try {
            EndpointPublisherImpl.stopWebApp((WebDeploymentController)deployment.getAttachment(WebDeploymentController.class));
        }
        finally {
            ClassLoader origClassLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
                DeploymentAspectManagerImpl dam = new DeploymentAspectManagerImpl();
                dam.setDeploymentAspects(aspects);
                dam.undeploy(deployment);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origClassLoader);
            }
        }
    }

    private static void stopWebApp(WebDeploymentController context) throws Exception {
        try {
            context.stop();
        }
        catch (Exception e) {
            throw WSMessages.MESSAGES.stopContextPhaseFailed(e);
        }
        try {
            context.destroy();
        }
        catch (Exception e) {
            throw WSMessages.MESSAGES.destroyContextPhaseFailed(e);
        }
    }

    private List<DeploymentAspect> getDeploymentAspects() {
        return this.runningInService ? DeploymentAspectsProvider.getSortedDeploymentAspects() : EndpointPublisherImpl.getPublisherDeploymentAspects();
    }

    private static synchronized List<DeploymentAspect> getPublisherDeploymentAspects() {
        if (depAspects == null) {
            depAspects = new LinkedList<DeploymentAspect>();
            List<DeploymentAspect> serverAspects = DeploymentAspectsProvider.getSortedDeploymentAspects();
            for (DeploymentAspect aspect : serverAspects) {
                if (aspect instanceof EndpointServiceDeploymentAspect) {
                    EndpointServiceDeploymentAspect a = (EndpointServiceDeploymentAspect)aspect;
                    EndpointServiceDeploymentAspect clone = (EndpointServiceDeploymentAspect)a.clone();
                    clone.setStopServices(true);
                    depAspects.add((DeploymentAspect)clone);
                    continue;
                }
                depAspects.add(aspect);
            }
        }
        return depAspects;
    }
}

