/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.Value;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefFactory;
import org.jboss.wsf.spi.serviceref.ServiceRefFactoryFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

final class WSRefValueSource
extends InjectionSource
implements Value<Object> {
    private final UnifiedServiceRefMetaData serviceRef;
    private final ClassLoader classLoader;

    WSRefValueSource(UnifiedServiceRefMetaData serviceRef, ClassLoader classLoader) {
        this.serviceRef = serviceRef;
        this.classLoader = classLoader;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        ValueManagedReferenceFactory factory = new ValueManagedReferenceFactory((Value)this);
        serviceBuilder.addInjection(injector, (Object)factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        ClassLoader oldCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            DelegateClassLoader integrationCL = new DelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), this.classLoader);
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)integrationCL);
            ServiceRefFactory serviceRefFactory = this.getServiceRefFactory();
            Object object = serviceRefFactory.newServiceRef(this.serviceRef);
            return object;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCL);
        }
    }

    private ServiceRefFactory getServiceRefFactory() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        return ((ServiceRefFactoryFactory)spiProvider.getSPI(ServiceRefFactoryFactory.class)).newServiceRefFactory();
    }
}

