/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.jboss.as.web.WebMessages;
import org.jboss.vfs.VirtualFile;

public class VFSDirContext
extends BaseDirContext {
    protected VirtualFile base = null;

    public VFSDirContext() {
    }

    public VFSDirContext(Hashtable env) {
        super(env);
    }

    protected VFSDirContext(VirtualFile base) {
        this.base = base;
    }

    public void setVirtualFile(VirtualFile base) {
        this.base = base;
    }

    public void release() {
        this.base = null;
        super.release();
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        VirtualFile entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(WebMessages.MESSAGES.resourceNotFound(name.toString()));
        }
        if (entry.isDirectory()) {
            return new VFSDirContext(entry);
        }
        return new VFSResource(entry);
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextEnumeration(this.list(this.base).iterator());
        }
        VirtualFile entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(WebMessages.MESSAGES.resourceNotFound(name.toString()));
        }
        return new NamingContextEnumeration(this.list(entry).iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextBindingsEnumeration(this.list(this.base).iterator(), (Context)((Object)this));
        }
        VirtualFile entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(WebMessages.MESSAGES.resourceNotFound(name.toString()));
        }
        return new NamingContextBindingsEnumeration(this.list(entry).iterator(), (Context)((Object)this));
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(new CompositeName(name), attrIds);
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        VirtualFile entry = null;
        entry = name.isEmpty() ? this.base : this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(WebMessages.MESSAGES.resourceNotFound(name.toString()));
        }
        ResourceAttributes attrs = new ResourceAttributes();
        attrs.setCreationDate(new Date(entry.getLastModified()));
        attrs.setName(entry.getName());
        if (entry.isFile()) {
            attrs.setResourceType("");
        } else {
            attrs.setCollection(true);
        }
        attrs.setContentLength(entry.getSize());
        attrs.setLastModified(entry.getLastModified());
        return attrs;
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected VirtualFile treeLookup(Name name) {
        if (this.base == null) {
            return null;
        }
        if (name.isEmpty()) {
            return this.base;
        }
        VirtualFile currentFile = this.base;
        for (int i = 0; i < name.size(); ++i) {
            if (name.get(i).length() == 0 || (currentFile = currentFile.getChild(name.get(i))).exists()) continue;
            return null;
        }
        return currentFile;
    }

    protected ArrayList<NamingEntry> list(VirtualFile entry) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        if (entry.isDirectory()) {
            Iterator children = entry.getChildren().iterator();
            NamingEntry namingEntry = null;
            while (children.hasNext()) {
                VirtualFile current = (VirtualFile)children.next();
                Object object = null;
                object = current.isDirectory() ? new VFSDirContext(current) : new VFSResource(current);
                namingEntry = new NamingEntry(current.getName(), object, 0);
                entries.add(namingEntry);
            }
        }
        return entries;
    }

    protected class VFSResource
    extends Resource {
        protected VirtualFile entry;

        public VFSResource(VirtualFile entry) {
            this.entry = entry;
        }

        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                InputStream is;
                this.inputStream = is = this.entry.openStream();
                return is;
            }
            return super.streamContent();
        }
    }
}

