/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.session;

import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.web.session.ClusteredSession;
import org.jboss.as.web.session.SnapshotManager;

public final class SessionReplicationContext {
    private static final ThreadLocal<SessionReplicationContext> replicationContext = new ThreadLocal();
    private static final SessionReplicationContext EMPTY = new SessionReplicationContext();
    private int webappCount;
    private SnapshotManager soleManager;
    private ClusteredSession<? extends OutgoingDistributableSessionData> soleSession;
    private Map<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager> crossCtxSessions;
    private Request outerRequest;
    private Response outerResponse;

    public static void enterWebapp(Request request, Response response, boolean startCacheActivity) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx == null) {
            ctx = new SessionReplicationContext(request, response);
            replicationContext.set(ctx);
        }
        ++ctx.webappCount;
    }

    public static SessionReplicationContext exitWebapp() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null) {
            --ctx.webappCount;
            if (ctx.webappCount < 1) {
                ctx.outerRequest = null;
                ctx.outerResponse = null;
                replicationContext.set(null);
                return ctx;
            }
        }
        return EMPTY;
    }

    public static void bindSession(ClusteredSession<? extends OutgoingDistributableSessionData> session, SnapshotManager manager) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null && ctx.webappCount > 0) {
            ctx.addReplicatableSession(session, manager);
        }
    }

    public static void sessionExpired(ClusteredSession<? extends OutgoingDistributableSessionData> session, String realId, SnapshotManager manager) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null && ctx.webappCount > 0) {
            ctx.sessionExpired(session, manager);
        }
    }

    public static boolean isLocallyActive() {
        return SessionReplicationContext.getCurrentContext() != null;
    }

    public static Request getOriginalRequest() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        return ctx == null ? null : ctx.outerRequest;
    }

    public static Response getOriginalResponse() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        return ctx == null ? null : ctx.outerResponse;
    }

    private static SessionReplicationContext getCurrentContext() {
        return replicationContext.get();
    }

    private SessionReplicationContext(Request request, Response response) {
        this.outerRequest = request;
        this.outerResponse = response;
    }

    private SessionReplicationContext() {
    }

    public Map<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager> getCrossContextSessions() {
        return this.crossCtxSessions;
    }

    public SnapshotManager getSoleSnapshotManager() {
        return this.soleManager;
    }

    public ClusteredSession<? extends OutgoingDistributableSessionData> getSoleSession() {
        return this.soleSession;
    }

    private void addReplicatableSession(ClusteredSession<? extends OutgoingDistributableSessionData> session, SnapshotManager mgr) {
        if (this.crossCtxSessions != null) {
            this.crossCtxSessions.put(session, mgr);
        } else if (this.soleManager == null) {
            this.soleManager = mgr;
            this.soleSession = session;
        } else if (!mgr.equals(this.soleManager)) {
            this.crossCtxSessions = new HashMap<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager>();
            this.crossCtxSessions.put(this.soleSession, this.soleManager);
            this.crossCtxSessions.put(session, mgr);
            this.soleManager = null;
            this.soleSession = null;
        } else {
            this.soleSession = session;
        }
    }

    private void sessionExpired(ClusteredSession<? extends OutgoingDistributableSessionData> session, SnapshotManager manager) {
        if (manager.equals(this.soleManager)) {
            this.soleManager = null;
            this.soleSession = null;
        } else if (this.crossCtxSessions != null) {
            this.crossCtxSessions.remove(session);
        }
    }
}

