/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.value.Value;

final class ManagedReferenceMethodInjectionInterceptorFactory
implements InterceptorFactory {
    private final Object targetContextKey;
    private final Object valueContextKey;
    private final Value<ManagedReferenceFactory> factoryValue;
    private final Method method;
    private final boolean optional;

    ManagedReferenceMethodInjectionInterceptorFactory(Object targetContextKey, Object valueContextKey, Value<ManagedReferenceFactory> factoryValue, Method method, boolean optional) {
        this.targetContextKey = targetContextKey;
        this.valueContextKey = valueContextKey;
        this.factoryValue = factoryValue;
        this.method = method;
        this.optional = optional;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        return new ManagedReferenceMethodInjectionInterceptor(this.targetContextKey, this.valueContextKey, (ManagedReferenceFactory)this.factoryValue.getValue(), this.method, this.optional);
    }

    static final class ManagedReferenceMethodInjectionInterceptor
    implements Interceptor {
        private final Object targetKey;
        private final Object valueKey;
        private final ManagedReferenceFactory factory;
        private final Method method;
        private final boolean optional;

        ManagedReferenceMethodInjectionInterceptor(Object targetKey, Object valueKey, ManagedReferenceFactory factory, Method method, boolean optional) {
            this.targetKey = targetKey;
            this.factory = factory;
            this.method = method;
            this.optional = optional;
            this.valueKey = valueKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            Object target;
            ComponentInstance componentInstance = (ComponentInstance)context.getPrivateData(ComponentInstance.class);
            if (Modifier.isStatic(this.method.getModifiers())) {
                target = null;
            } else {
                target = ((ManagedReference)componentInstance.getInstanceData(this.targetKey)).getInstance();
                if (target == null) {
                    throw EeLogger.ROOT_LOGGER.injectionTargetNotFound();
                }
            }
            ManagedReference reference = this.factory.getReference();
            if (reference == null && this.optional) {
                return context.proceed();
            }
            boolean ok = false;
            try {
                componentInstance.setInstanceData(this.valueKey, reference);
                InvocationType invocationType = (InvocationType)((Object)context.getPrivateData(InvocationType.class));
                try {
                    context.putPrivateData(InvocationType.class, (Object)InvocationType.DEPENDENCY_INJECTION);
                    this.method.invoke(target, reference.getInstance());
                }
                finally {
                    context.putPrivateData(InvocationType.class, (Object)invocationType);
                }
                Object result = context.proceed();
                ok = true;
                Object object = result;
                return object;
            }
            finally {
                if (!ok) {
                    componentInstance.setInstanceData(this.valueKey, null);
                    reference.release();
                }
            }
        }
    }
}

