/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;

public final class InjectionUtils {
    private InjectionUtils() {
    }

    public static AccessibleObject getInjectionTarget(String injectionTargetClassName, String injectionTargetName, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        Class<?> current;
        Class<?> injectionTargetClass;
        try {
            injectionTargetClass = classLoader.loadClass(injectionTargetClassName);
        }
        catch (ClassNotFoundException e) {
            throw EeLogger.ROOT_LOGGER.cannotLoad(e, injectionTargetClassName);
        }
        ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(injectionTargetClass);
        String methodName = "set" + injectionTargetName.substring(0, 1).toUpperCase(Locale.ENGLISH) + injectionTargetName.substring(1);
        boolean methodFound = false;
        AccessibleObject method = null;
        Field field = null;
        for (current = injectionTargetClass; current != Object.class && current != null && !methodFound; current = current.getSuperclass()) {
            Collection methods = index.getAllMethods(methodName);
            for (Method m : methods) {
                if (m.getParameterCount() != 1 || m.isBridge() || m.isSynthetic()) continue;
                if (methodFound) {
                    throw EeLogger.ROOT_LOGGER.multipleSetterMethodsFound(injectionTargetName, injectionTargetClassName);
                }
                methodFound = true;
                method = m;
            }
        }
        if (method == null) {
            for (current = injectionTargetClass; current != Object.class && current != null && field == null && (field = index.getField(injectionTargetName)) == null; current = current.getSuperclass()) {
            }
        }
        if (field == null && method == null) {
            throw EeLogger.ROOT_LOGGER.cannotResolveInjectionPoint(injectionTargetName, injectionTargetClassName);
        }
        return field != null ? field : method;
    }
}

