/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.deployment.ApplicableMethodInformation;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.JaccInterceptor;
import org.jboss.as.ejb3.security.RolesAllowedInterceptor;
import org.jboss.as.ejb3.security.service.EJBViewMethodSecurityAttributesService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class EJBSecurityViewConfigurator
implements ViewConfigurator {
    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription viewDescription, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
        Boolean denyAccessToMethodsMissingPermissions;
        boolean securityRequired;
        ServiceName viewMethodSecurityAttributesServiceName;
        EJBViewMethodSecurityAttributesService.Builder viewMethodSecurityAttributesServiceBuilder;
        if (!(componentConfiguration.getComponentDescription() instanceof EJBComponentDescription)) {
            throw EjbLogger.ROOT_LOGGER.invalidEjbComponent(componentConfiguration.getComponentName(), componentConfiguration.getComponentClass());
        }
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        boolean elytronSecurityDomain = ejbComponentDescription.getSecurityDomainServiceName() != null;
        String viewClassName = viewDescription.getViewClassName();
        EJBViewDescription ejbViewDescription = (EJBViewDescription)viewDescription;
        if (MethodInterfaceType.ServiceEndpoint == ejbViewDescription.getMethodIntf()) {
            viewMethodSecurityAttributesServiceBuilder = new EJBViewMethodSecurityAttributesService.Builder();
            viewMethodSecurityAttributesServiceName = EJBViewMethodSecurityAttributesService.getServiceName(ejbComponentDescription.getApplicationName(), ejbComponentDescription.getModuleName(), ejbComponentDescription.getEJBName(), viewClassName);
        } else {
            viewMethodSecurityAttributesServiceBuilder = null;
            viewMethodSecurityAttributesServiceName = null;
        }
        if (!elytronSecurityDomain) {
            this.installAttributeServiceIfRequired(context, viewMethodSecurityAttributesServiceBuilder, viewMethodSecurityAttributesServiceName);
            return;
        }
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        String resolvedSecurityDomain = ejbComponentDescription.getResolvedSecurityDomain();
        if (!elytronSecurityDomain && (resolvedSecurityDomain == null || resolvedSecurityDomain.isEmpty())) {
            if (EjbLogger.ROOT_LOGGER.isDebugEnabled()) {
                EjbLogger.ROOT_LOGGER.debug("Security is *not* enabled on EJB: " + ejbComponentDescription.getEJBName() + ", since no explicit security domain is configured for the bean, nor is there any default security domain configured in the EJB3 subsystem");
            }
            this.installAttributeServiceIfRequired(context, viewMethodSecurityAttributesServiceBuilder, viewMethodSecurityAttributesServiceName);
            return;
        }
        Object contextID = deploymentUnit.getName();
        if (deploymentUnit.getParent() != null) {
            contextID = deploymentUnit.getParent().getName() + "!" + (String)contextID;
        }
        boolean beanHasMethodLevelSecurityMetadata = false;
        List viewMethods = viewConfiguration.getProxyFactory().getCachedMethods();
        ArrayList<Method> methodsWithoutExplicitSecurityConfiguration = new ArrayList<Method>();
        for (Method viewMethod : viewMethods) {
            if (!Modifier.isPublic(viewMethod.getModifiers()) || viewMethod.getDeclaringClass() == WriteReplaceInterface.class) continue;
            ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions = ejbComponentDescription.getDescriptorMethodPermissions();
            boolean methodHasSecurityMetadata = this.handlePermissions((String)contextID, componentConfiguration, viewConfiguration, deploymentReflectionIndex, viewClassName, ejbViewDescription, viewMethod, permissions, false, viewMethodSecurityAttributesServiceBuilder, ejbComponentDescription, elytronSecurityDomain, resolvedSecurityDomain);
            if (!methodHasSecurityMetadata) {
                methodHasSecurityMetadata = this.handlePermissions((String)contextID, componentConfiguration, viewConfiguration, deploymentReflectionIndex, viewClassName, ejbViewDescription, viewMethod, ejbComponentDescription.getAnnotationMethodPermissions(), true, viewMethodSecurityAttributesServiceBuilder, ejbComponentDescription, elytronSecurityDomain, resolvedSecurityDomain);
            }
            if (methodHasSecurityMetadata) {
                beanHasMethodLevelSecurityMetadata = true;
                continue;
            }
            methodsWithoutExplicitSecurityConfiguration.add(viewMethod);
        }
        boolean bl = securityRequired = beanHasMethodLevelSecurityMetadata || ejbComponentDescription.hasBeanLevelSecurityMetadata();
        if (securityRequired) {
            ejbComponentDescription.setSecurityRequired(securityRequired);
        }
        if (elytronSecurityDomain) {
            HashMap<Integer, InterceptorFactory> elytronInterceptorFactories = ejbComponentDescription.getElytronInterceptorFactories((String)contextID, ejbComponentDescription.requiresJacc(), true);
            elytronInterceptorFactories.forEach((priority, elytronInterceptorFactory) -> viewConfiguration.addViewInterceptor(elytronInterceptorFactory, priority.intValue()));
        } else if (securityRequired) {
            throw EjbLogger.ROOT_LOGGER.legacySecurityUnsupported(resolvedSecurityDomain);
        }
        if (securityRequired && (denyAccessToMethodsMissingPermissions = ((EJBComponentDescription)componentConfiguration.getComponentDescription()).isMissingMethodPermissionsDeniedAccess()) != Boolean.FALSE) {
            for (Method viewMethod : methodsWithoutExplicitSecurityConfiguration) {
                if (viewMethodSecurityAttributesServiceBuilder != null) {
                    viewMethodSecurityAttributesServiceBuilder.addMethodSecurityMetadata(viewMethod, EJBMethodSecurityAttribute.denyAll());
                }
                if (elytronSecurityDomain) {
                    viewConfiguration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)RolesAllowedInterceptor.DENY_ALL), 768);
                    continue;
                }
                throw EjbLogger.ROOT_LOGGER.legacySecurityUnsupported(resolvedSecurityDomain);
            }
        }
        this.installAttributeServiceIfRequired(context, viewMethodSecurityAttributesServiceBuilder, viewMethodSecurityAttributesServiceName);
    }

    private void installAttributeServiceIfRequired(DeploymentPhaseContext context, EJBViewMethodSecurityAttributesService.Builder viewMethodSecurityAttributesServiceBuilder, ServiceName viewMethodSecurityAttributesServiceName) {
        if (viewMethodSecurityAttributesServiceBuilder != null) {
            EJBViewMethodSecurityAttributesService viewMethodSecurityAttributesService = viewMethodSecurityAttributesServiceBuilder.build();
            context.getServiceTarget().addService(viewMethodSecurityAttributesServiceName, (Service)viewMethodSecurityAttributesService).install();
        }
    }

    private boolean handlePermissions(String contextID, ComponentConfiguration componentConfiguration, ViewConfiguration viewConfiguration, DeploymentReflectionIndex deploymentReflectionIndex, String viewClassName, EJBViewDescription ejbViewDescription, Method viewMethod, ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions, boolean annotations, EJBViewMethodSecurityAttributesService.Builder viewMethodSecurityAttributesServiceBuilder, EJBComponentDescription componentDescription, boolean elytronSecurityDomain, String resolvedSecurityDomain) {
        EJBMethodSecurityAttribute ejbMethodSecurityMetaData = permissions.getViewAttribute(ejbViewDescription.getMethodIntf(), viewMethod);
        ArrayList<EJBMethodSecurityAttribute> allAttributes = new ArrayList<EJBMethodSecurityAttribute>();
        allAttributes.addAll(permissions.getAllAttributes(ejbViewDescription.getMethodIntf(), viewMethod));
        if (ejbMethodSecurityMetaData == null) {
            ejbMethodSecurityMetaData = permissions.getViewAttribute(MethodInterfaceType.Bean, viewMethod);
        }
        allAttributes.addAll(permissions.getAllAttributes(MethodInterfaceType.Bean, viewMethod));
        Method classMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (Class)componentConfiguration.getComponentClass(), (Method)viewMethod);
        if (ejbMethodSecurityMetaData == null && classMethod != null && (ejbMethodSecurityMetaData = permissions.getAttribute(ejbViewDescription.getMethodIntf(), classMethod)) == null) {
            ejbMethodSecurityMetaData = permissions.getAttribute(MethodInterfaceType.Bean, classMethod);
        }
        if (classMethod != null) {
            allAttributes.addAll(permissions.getAllAttributes(ejbViewDescription.getMethodIntf(), classMethod));
            allAttributes.addAll(permissions.getAllAttributes(MethodInterfaceType.Bean, classMethod));
        }
        if (ejbMethodSecurityMetaData != null) {
            Object authorizationInterceptor;
            if (!(annotations || ejbMethodSecurityMetaData.isDenyAll() || ejbMethodSecurityMetaData.isPermitAll())) {
                HashSet<String> rolesAllowed = new HashSet<String>();
                for (EJBMethodSecurityAttribute attr : allAttributes) {
                    rolesAllowed.addAll(attr.getRolesAllowed());
                }
                ejbMethodSecurityMetaData = EJBMethodSecurityAttribute.rolesAllowed(rolesAllowed);
            }
            if (viewMethodSecurityAttributesServiceBuilder != null) {
                viewMethodSecurityAttributesServiceBuilder.addMethodSecurityMetadata(viewMethod, ejbMethodSecurityMetaData);
            }
            if (ejbMethodSecurityMetaData.isPermitAll()) {
                return true;
            }
            if (elytronSecurityDomain) {
                authorizationInterceptor = ejbMethodSecurityMetaData.isDenyAll() ? RolesAllowedInterceptor.DENY_ALL : (componentDescription.requiresJacc() ? new JaccInterceptor(viewClassName, viewMethod) : new RolesAllowedInterceptor(ejbMethodSecurityMetaData.getRolesAllowed()));
            } else {
                throw EjbLogger.ROOT_LOGGER.legacySecurityUnsupported(resolvedSecurityDomain);
            }
            viewConfiguration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)authorizationInterceptor), 768);
            return true;
        }
        return false;
    }
}

