/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import javax.security.auth.Subject;
import org.jboss.as.controller.security.AccessMechanismPrincipal;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.remotingjmx.ServerMessageInterceptor;
import org.jboss.remotingjmx.ServerMessageInterceptorFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

class ServerInterceptorFactory
implements ServerMessageInterceptorFactory {
    ServerInterceptorFactory() {
    }

    public ServerMessageInterceptor create(Channel channel) {
        return new Interceptor(channel);
    }

    private static class Interceptor
    implements ServerMessageInterceptor {
        private final Channel channel;

        private Interceptor(Channel channel) {
            this.channel = channel;
        }

        public void handleEvent(final ServerMessageInterceptor.Event event) throws IOException {
            UserInfo userInfo = this.channel.getConnection().getUserInfo();
            if (userInfo instanceof SubjectUserInfo) {
                Subject subject;
                Subject useSubject = subject = ((SubjectUserInfo)userInfo).getSubject();
                PrivilegedAction<Subject> copyAction = new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        Subject copySubject = new Subject();
                        copySubject.getPrincipals().addAll(subject.getPrincipals());
                        copySubject.getPrivateCredentials().addAll(subject.getPrivateCredentials());
                        copySubject.getPublicCredentials().addAll(subject.getPublicCredentials());
                        Collection principals = Interceptor.this.channel.getConnection().getPrincipals();
                        for (Principal principal : principals) {
                            if (!(principal instanceof org.jboss.remoting3.security.InetAddressPrincipal)) continue;
                            copySubject.getPrincipals().add((Principal)new InetAddressPrincipal(((org.jboss.remoting3.security.InetAddressPrincipal)principal).getInetAddress()));
                            break;
                        }
                        copySubject.getPrincipals().add((Principal)new AccessMechanismPrincipal(AccessMechanism.JMX));
                        copySubject.setReadOnly();
                        return copySubject;
                    }
                };
                useSubject = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(copyAction) : (Subject)copyAction.run();
                try {
                    Subject.doAs(useSubject, new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            event.run();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception cause = e.getException();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new IOException(cause);
                }
            } else {
                event.run();
            }
        }
    }
}

