/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.jboss.as.naming.ServiceAwareObjectFactory;
import org.jboss.as.naming.context.ModularReference;
import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;

public class ServiceReferenceObjectFactory
implements ServiceAwareObjectFactory {
    private volatile ServiceRegistry serviceRegistry;

    public static Reference createReference(ServiceName service, Class<? extends ServiceReferenceObjectFactory> factory) {
        return ModularReference.create(Context.class, (RefAddr)new ServiceNameRefAdr("srof", service), factory);
    }

    @Override
    public void injectServiceRegistry(ServiceRegistry registry) {
        this.serviceRegistry = registry;
    }

    @Override
    public final Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference reference = (Reference)obj;
        ServiceNameRefAdr nameAdr = (ServiceNameRefAdr)reference.get("srof");
        if (nameAdr == null) {
            throw NamingLogger.ROOT_LOGGER.invalidContextReference("srof");
        }
        ServiceName serviceName = (ServiceName)nameAdr.getContent();
        try {
            ServiceController controller = this.serviceRegistry.getRequiredService(serviceName);
            return this.getObjectInstance(controller.awaitValue(), obj, name, nameCtx, environment);
        }
        catch (ServiceNotFoundException e) {
            throw NamingLogger.ROOT_LOGGER.cannotResolveService(serviceName);
        }
        catch (InterruptedException e) {
            throw NamingLogger.ROOT_LOGGER.threadInterrupt(serviceName);
        }
        catch (Throwable t) {
            throw NamingLogger.ROOT_LOGGER.cannotResolveService(serviceName, this.getClass().getName(), "START_FAILED");
        }
    }

    public Object getObjectInstance(Object serviceValue, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        return serviceValue;
    }

    private static final class ServiceNameRefAdr
    extends RefAddr {
        private static final long serialVersionUID = 3677121114687908679L;
        private final ServiceName serviceName;

        private ServiceNameRefAdr(String s, ServiceName serviceName) {
            super(s);
            this.serviceName = serviceName;
        }

        @Override
        public Object getContent() {
            return this.serviceName;
        }
    }
}

