/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.security.Principal;
import java.util.Collection;
import org.jboss.as.security.SecurityMessages;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.security.UserPrincipal;

public final class RemotingConnectionPrincipal
implements Principal {
    private final Connection connection;
    private final String name;
    private final int hashCode;

    public RemotingConnectionPrincipal(Connection connection) {
        this.connection = connection;
        Collection principals = connection.getPrincipals();
        String userName = null;
        for (Principal current : principals) {
            if (!(current instanceof UserPrincipal)) continue;
            userName = current.getName();
            break;
        }
        if (userName == null) {
            throw SecurityMessages.MESSAGES.noUserPrincipalFound();
        }
        this.name = userName;
        this.hashCode = connection.hashCode() * this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RemotingConnectionPrincipal ? this.equals((RemotingConnectionPrincipal)obj) : false;
    }

    public boolean equals(RemotingConnectionPrincipal obj) {
        return this.connection.equals(obj.connection);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

