/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.security.vault.SecurityVaultException;

@MessageBundle(projectCode="")
public interface VaultMessages {
    public static final VaultMessages MESSAGES = (VaultMessages)Messages.getBundle(VaultMessages.class);

    @Message(id=21000, value="Keystore '%s' doesn't exist.\nkeystore could be created: keytool -genseckey -alias Vault -storetype jceks -keyalg AES -keysize 128 -storepass secretsecret -keypass secretsecret -keystore %s")
    public Exception keyStoreDoesnotExistWithExample(String var1, String var2);

    @Message(id=21001, value="Keystore [%s] is not writable or not a file.")
    public Exception keyStoreNotWritable(String var1);

    @Message(id=21002, value="Keystore password has to be specified.")
    public Exception keyStorePasswordNotSpecified();

    @Message(id=21003, value="Encryption directory has to be specified.")
    public Exception encryptionDirectoryHasToBeSpecified();

    @Message(id=21004, value="Encryption directory is not a directory or doesn't exist. (%s)")
    public Exception encryptionDirectoryDoesNotExist(String var1);

    @Message(id=21005, value="Cannot create encryption directory %s")
    public Exception cannotCreateEncryptionDirectory(String var1);

    @Message(id=21006, value="Iteration count has to be within 1 - 2147483647, but it is %s.")
    public Exception iterationCountOutOfRange(String var1);

    @Message(id=21007, value="Salt has to be exactly 8 characters long.")
    public Exception saltWrongLength();

    @Message(id=21008, value="Exception encountered:")
    public Exception securityVaultException(@Cause SecurityVaultException var1);

    @Message(id=21009, value="Vault alias has to be specified.")
    public Exception vaultAliasNotSpecified();

    @Message(id=21010, value="Secured attribute value has been stored in Vault.\nPlease make note of the following:\n********************************************\nVault Block:%s\nAttribute Name:%s\nConfiguration should be done as follows:\n%s\n********************************************")
    public String vaultAttributeCreateDisplay(String var1, String var2, String var3);

    @Message(id=21011, value="Vault Configuration in WildFly configuration file:")
    public String vaultConfigurationTitle();

    @Message(id=21012, value="No console.")
    public String noConsole();

    @Message(id=21013, value="Enter directory to store encrypted files:")
    public String enterEncryptionDirectory();

    @Message(id=21014, value="Enter Keystore URL:")
    public String enterKeyStoreURL();

    @Message(id=21015, value="Enter Keystore password")
    public String enterKeyStorePassword();

    @Message(id=21016, value="Enter 8 character salt:")
    public String enterSalt();

    @Message(id=21017, value="Enter iteration count as a number (e.g.: 44):")
    public String enterIterationCount();

    @Message(id=21018, value="Enter Keystore Alias:")
    public String enterKeyStoreAlias();

    @Message(id=21019, value="Initializing Vault")
    public String initializingVault();

    @Message(id=21020, value="Vault is initialized and ready for use")
    public String vaultInitialized();

    @Message(id=21021, value="Handshake with Vault complete")
    public String handshakeComplete();

    @Message(id=21022, value="Exception encountered:")
    public String exceptionEncountered();

    @Message(id=21023, value="Enter your password")
    public String enterYourPassword();

    @Message(id=21024, value=" again: ")
    public String passwordAgain();

    @Message(id=21025, value="Values entered don't match")
    public String passwordsDoNotMatch();

    @Message(id=21026, value="Values match")
    public String passwordsMatch();

    @Message(id=21027, value="Problem occurred:")
    public String problemOcurred();

    @Message(id=21028, value="Please enter a Digit::   0: Start Interactive Session   1: Remove Interactive Session  2: Exit")
    public String interactiveCommandString();

    @Message(id=21029, value="Starting an interactive session")
    public String startingInteractiveSession();

    @Message(id=21030, value="Removing the current interactive session")
    public String removingInteractiveSession();

    @Message(id=21031, value="Problem while parsing command line parameters:")
    public String problemParsingCommandLineParameters();

    @Message(id=21032, value="Keystore URL")
    public String cmdLineKeyStoreURL();

    @Message(id=21033, value="Keystore password")
    public String cmdLineKeyStorePassword();

    @Message(id=21034, value="Directory containing encrypted files")
    public String cmdLineEncryptionDirectory();

    @Message(id=21035, value="8 character salt")
    public String cmdLineSalt();

    @Message(id=21036, value="Iteration count")
    public String cmdLineIterationCount();

    @Message(id=21037, value="Vault keystore alias")
    public String cmdLineVaultKeyStoreAlias();

    @Message(id=21038, value="Vault block")
    public String cmdLineVaultBlock();

    @Message(id=21039, value="Attribute name")
    public String cmdLineAttributeName();

    @Message(id=21040, value="Secured attribute value (such as password) to store")
    public String cmdLineSecuredAttribute();

    @Message(id=21041, value="Check whether the secured attribute already exists in the Vault")
    public String cmdLineCheckAttribute();

    @Message(id=21042, value="Help")
    public String cmdLineHelp();

    @Message(id=21043, value="Secured attribute (password) already exists.")
    public String cmdLineSecuredAttributeAlreadyExists();

    @Message(id=21044, value="Secured attribute (password) doesn't exist.")
    public String cmdLineSecuredAttributeDoesNotExist();
}

