/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.io.File;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.NativeLibraryResourceLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;

public class ModuleLoadingResourceDefinition
extends SimpleResourceDefinition {
    private static final AttributeDefinition MODULE_NAME = new SimpleAttributeDefinitionBuilder("module", ModelType.STRING).build();
    private final List<AccessConstraintDefinition> accessConstraints = SensitiveTargetAccessConstraintDefinition.MODULE_LOADING.wrapAsList();

    public ModuleLoadingResourceDefinition() {
        super(PathElement.pathElement((String)"core-service", (String)"module-loading"), ServerDescriptions.getResourceDescriptionResolver("core", "module-loading"));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        SimpleListAttributeDefinition ad = ((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)SimpleListAttributeDefinition.Builder.of((String)"module-roots", (AttributeDefinition)new SimpleAttributeDefinitionBuilder("module-root", ModelType.STRING).build()).setStorageRuntime()).setDeprecated(ModelVersion.create((int)1, (int)4, (int)0))).build();
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ad, (OperationStepHandler)new ListModuleRootsHandler());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        SimpleOperationDefinition definition = new SimpleOperationDefinitionBuilder("list-resource-loader-paths", this.getResourceDescriptionResolver()).addParameter(MODULE_NAME).setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).setDeprecated(ModelVersion.create((int)1, (int)4, (int)0)).setReadOnly().build();
        resourceRegistration.registerOperationHandler((OperationDefinition)definition, (OperationStepHandler)new ModuleLocationHandler());
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> findResourcePaths(String moduleName) throws ModuleLoadException, NoSuchFieldException, IllegalAccessException {
        ArrayList<String> result = new ArrayList<String>();
        Module module = Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)moduleName));
        ModuleClassLoader mcl = module.getClassLoader();
        Field pathsField = ModuleClassLoader.class.getDeclaredField("paths");
        Field sourceListField = null;
        Field resourceLoaderField = null;
        pathsField.setAccessible(true);
        try {
            Object paths = pathsField.get(mcl);
            sourceListField = paths.getClass().getDeclaredField("sourceList");
            sourceListField.setAccessible(true);
            Object[] resourceLoaderSpecs = (Object[])sourceListField.get(paths);
            resourceLoaderField = ResourceLoaderSpec.class.getDeclaredField("resourceLoader");
            resourceLoaderField.setAccessible(true);
            for (Object resourceLoaderSpec : resourceLoaderSpecs) {
                ResourceLoader resourceLoader = (ResourceLoader)resourceLoaderField.get(resourceLoaderSpec);
                String path = ModuleLoadingResourceDefinition.getResourceLoaderPath(resourceLoader);
                if (path == null) continue;
                result.add(path);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            pathsField.setAccessible(false);
            if (sourceListField != null) {
                sourceListField.setAccessible(false);
            }
            if (resourceLoaderField != null) {
                resourceLoaderField.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceLoaderPath(ResourceLoader resourceLoader) throws NoSuchFieldException, IllegalAccessException {
        if (resourceLoader instanceof NativeLibraryResourceLoader) {
            return ((NativeLibraryResourceLoader)resourceLoader).getRoot().getAbsolutePath();
        }
        if (ModuleLoadingResourceDefinition.isInstanceOf(resourceLoader, "org.jboss.modules.JarFileResourceLoader")) {
            Field fileOfJarField = resourceLoader.getClass().getDeclaredField("fileOfJar");
            fileOfJarField.setAccessible(true);
            try {
                File fileOfJar = (File)fileOfJarField.get(resourceLoader);
                String string = fileOfJar.getAbsolutePath();
                return string;
            }
            finally {
                fileOfJarField.setAccessible(false);
            }
        }
        if (ModuleLoadingResourceDefinition.isInstanceOf(resourceLoader, "org.jboss.modules.FilteredResourceLoader")) {
            Field loaderField = resourceLoader.getClass().getDeclaredField("loader");
            loaderField.setAccessible(true);
            try {
                ResourceLoader loader = (ResourceLoader)loaderField.get(resourceLoader);
                String string = ModuleLoadingResourceDefinition.getResourceLoaderPath(loader);
                return string;
            }
            finally {
                loaderField.setAccessible(false);
            }
        }
        return null;
    }

    private static boolean isInstanceOf(Object obj, String className) {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getCanonicalName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private static final class ModuleLocationHandler
    implements OperationStepHandler {
        private ModuleLocationHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final String moduleName = MODULE_NAME.resolveModelAttribute(context, operation).asString();
                    try {
                        List<String> paths = AccessController.doPrivileged(new PrivilegedExceptionAction<List<String>>(){

                            @Override
                            public List<String> run() throws Exception {
                                return ModuleLoadingResourceDefinition.findResourcePaths(moduleName);
                            }
                        });
                        ModelNode list = context.getResult().setEmptyList();
                        for (String path : paths) {
                            list.add(path);
                        }
                    }
                    catch (PrivilegedActionException e) {
                        throw new OperationFailedException(e.getCause());
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
            context.stepCompleted();
        }
    }

    private static class ListModuleRootsHandler
    extends AbstractRuntimeOnlyHandler {
        private ListModuleRootsHandler() {
        }

        protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
            return false;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ModelNode list = context.getResult().setEmptyList();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        ListModuleRootsHandler.storeRepoRoots(list);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new IllegalStateException(e.getCause());
            }
            context.stepCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void storeRepoRoots(ModelNode list) throws NoSuchFieldException, IllegalAccessException {
            ModuleLoader loader = Module.getBootModuleLoader();
            if (loader instanceof LocalModuleLoader) {
                LocalModuleLoader lml = (LocalModuleLoader)loader;
                Field findersField = ModuleLoader.class.getDeclaredField("finders");
                Field repoRootsField = null;
                findersField.setAccessible(true);
                try {
                    Object[] finders = (Object[])findersField.get(lml);
                    if (finders.length > 0 && finders[0] instanceof LocalModuleFinder) {
                        File[] repoRoots;
                        LocalModuleFinder lmf = (LocalModuleFinder)finders[0];
                        repoRootsField = LocalModuleFinder.class.getDeclaredField("repoRoots");
                        repoRootsField.setAccessible(true);
                        for (File file : repoRoots = (File[])repoRootsField.get(lmf)) {
                            list.add(file.getAbsolutePath());
                        }
                    }
                }
                finally {
                    findersField.setAccessible(false);
                    if (repoRootsField != null) {
                        repoRootsField.setAccessible(false);
                    }
                }
            }
        }
    }
}

