/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.session.PathParameterSessionConfig;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.SessionConfigWrapper;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.web.session.AffinityLocator;
import org.wildfly.extension.undertow.CookieConfig;
import org.wildfly.extension.undertow.session.AffinitySessionConfig;

public class AffinitySessionConfigWrapper
implements SessionConfigWrapper {
    private final Map<SessionConfig.SessionCookieSource, SessionConfig> affinityConfigMap = new EnumMap<SessionConfig.SessionCookieSource, SessionConfig>(SessionConfig.SessionCookieSource.class);
    private final AffinityLocator locator;

    public AffinitySessionConfigWrapper(CookieConfig config, AffinityLocator locator) {
        this.locator = locator;
        SessionCookieConfig cookieSessionConfig = new SessionCookieConfig();
        cookieSessionConfig.setCookieName(config.getName());
        if (config.getDomain() != null) {
            cookieSessionConfig.setDomain(config.getDomain());
        }
        if (config.getHttpOnly() != null) {
            cookieSessionConfig.setHttpOnly(config.getHttpOnly().booleanValue());
        }
        if (config.getSecure() != null) {
            cookieSessionConfig.setSecure(config.getSecure().booleanValue());
        }
        if (config.getMaxAge() != null) {
            cookieSessionConfig.setMaxAge(config.getMaxAge().intValue());
        }
        this.affinityConfigMap.put(SessionConfig.SessionCookieSource.COOKIE, (SessionConfig)cookieSessionConfig);
        String pathParameterName = config.getName().toLowerCase(Locale.ENGLISH);
        PathParameterSessionConfig pathParameterSessionConfig = new PathParameterSessionConfig(pathParameterName);
        this.affinityConfigMap.put(SessionConfig.SessionCookieSource.URL, (SessionConfig)pathParameterSessionConfig);
    }

    public SessionConfig wrap(SessionConfig sessionConfig, Deployment deployment) {
        return new AffinitySessionConfig(sessionConfig, this.affinityConfigMap, this.locator);
    }
}

