/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.context;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import wiremock.com.github.jknack.handlebars.ValueResolver;
import wiremock.com.github.jknack.handlebars.internal.lang3.Validate;

public abstract class MemberValueResolver<M extends Member>
implements ValueResolver {
    private final Map<Class<?>, Map<String, M>> cache = new ConcurrentHashMap();

    @Override
    public final Object resolve(Object context, String name) {
        Class<?> key = context.getClass();
        Map<String, M> mcache = this.cache(key);
        Member member = (Member)mcache.get(name);
        if (member == null) {
            return UNRESOLVED;
        }
        return this.invokeMember(member, context);
    }

    @Override
    public Object resolve(Object context) {
        return UNRESOLVED;
    }

    private Map<String, M> cache(Class<?> clazz) {
        Map<String, M> mcache = this.cache.get(clazz);
        if (mcache == null) {
            mcache = new HashMap<String, M>();
            Set<M> members = this.members(clazz);
            for (Member m4 : members) {
                if (this.isUseSetAccessible(m4) && m4 instanceof AccessibleObject) {
                    ((AccessibleObject)((Object)m4)).setAccessible(true);
                }
                mcache.put(this.memberName(m4), m4);
            }
            this.cache.put(clazz, mcache);
        }
        return mcache;
    }

    protected boolean isUseSetAccessible(M member) {
        String dn;
        Class<?> dc = member.getDeclaringClass();
        String string = dn = dc == null ? null : dc.getCanonicalName();
        return dn == null || !dn.startsWith("java.") && !dn.startsWith("sun.");
    }

    protected abstract Object invokeMember(M var1, Object var2);

    public abstract boolean matches(M var1, String var2);

    protected boolean isPublic(M member) {
        return Modifier.isPublic(member.getModifiers());
    }

    protected boolean isPrivate(M member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    protected boolean isProtected(M member) {
        return Modifier.isProtected(member.getModifiers());
    }

    protected boolean isStatic(M member) {
        return Modifier.isStatic(member.getModifiers());
    }

    protected abstract Set<M> members(Class<?> var1);

    @Override
    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        Validate.notNull(context, "The context is required.", new Object[0]);
        if (context instanceof Map) {
            return Collections.emptySet();
        }
        if (context instanceof Collection) {
            return Collections.emptySet();
        }
        Collection<M> members = this.cache(context.getClass()).values();
        LinkedHashMap<String, Object> propertySet = new LinkedHashMap<String, Object>();
        for (Member member : members) {
            String name = this.memberName(member);
            propertySet.put(name, this.resolve(context, name));
        }
        return propertySet.entrySet();
    }

    protected abstract String memberName(M var1);
}

