/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ResourceUtil;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;

public class HttpsSettings {
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyManagerPassword;
    private final String keyStoreType;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String trustStoreType;
    private final boolean needClientAuth;

    public HttpsSettings(int port, String keyStorePath, String keyStorePassword, String keyManagerPassword, String keyStoreType, String trustStorePath, String trustStorePassword, String trustStoreType, boolean needClientAuth) {
        this.port = port;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyManagerPassword = keyManagerPassword;
        this.keyStoreType = keyStoreType;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.needClientAuth = needClientAuth;
    }

    public int port() {
        return this.port;
    }

    public String keyStorePath() {
        return this.keyStorePath;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public String keyManagerPassword() {
        return this.keyManagerPassword;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public boolean enabled() {
        return this.port > -1;
    }

    public String trustStorePath() {
        return this.trustStorePath;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public String trustStoreType() {
        return this.trustStoreType;
    }

    public boolean needClientAuth() {
        return this.needClientAuth;
    }

    public boolean hasTrustStore() {
        return this.trustStorePath != null;
    }

    public KeyStoreSettings trustStore() {
        return this.trustStorePath != null ? new KeyStoreSettings(this.trustStorePath, this.trustStorePassword, this.trustStoreType) : KeyStoreSettings.NO_STORE;
    }

    public KeyStoreSettings keyStore() {
        return new KeyStoreSettings(this.keyStorePath, this.keyStorePassword, this.keyStoreType);
    }

    public String toString() {
        return "HttpsSettings{port=" + this.port + ", keyStorePath='" + this.keyStorePath + "', keyStoreType='" + this.keyStoreType + "', trustStorePath='" + this.trustStorePath + "', trustStoreType='" + this.trustStoreType + "', needClientAuth=" + this.needClientAuth + "}";
    }

    public static class Builder {
        private int port;
        private String keyStorePath = ResourceUtil.getResource(Builder.class, "keystore").toString();
        private String keyStorePassword = "password";
        private String keyManagerPassword = "password";
        private String keyStoreType = "JKS";
        private String trustStorePath = null;
        private String trustStorePassword = "password";
        private String trustStoreType = "JKS";
        private boolean needClientAuth = false;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder keyManagerPassword(String keyStorePassword) {
            this.keyManagerPassword = keyStorePassword;
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder needClientAuth(boolean needClientAuth) {
            this.needClientAuth = needClientAuth;
            return this;
        }

        public HttpsSettings build() {
            return new HttpsSettings(this.port, this.keyStorePath, this.keyStorePassword, this.keyManagerPassword, this.keyStoreType, this.trustStorePath, this.trustStorePassword, this.trustStoreType, this.needClientAuth);
        }
    }
}

