/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.i18n;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import wiremock.com.networknt.schema.i18n.MessageSource;

public class ResourceBundleMessageSource
implements MessageSource {
    private Map<String, Map<Locale, ResourceBundle>> resourceBundleMap = new ConcurrentHashMap<String, Map<Locale, ResourceBundle>>();
    private Map<Locale, Map<String, String>> messageMap = new ConcurrentHashMap<Locale, Map<String, String>>();
    private Map<Locale, Map<String, MessageFormat>> messageFormatMap = new ConcurrentHashMap<Locale, Map<String, MessageFormat>>();
    private final List<String> baseNames;

    public ResourceBundleMessageSource(String ... baseName) {
        this.baseNames = Arrays.asList(baseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage(String key, Supplier<String> defaultMessage, Locale locale, Object ... arguments) {
        MessageFormat messageFormat;
        String message = this.getMessageFromCache(locale, key);
        if (message.isEmpty() && defaultMessage != null) {
            message = defaultMessage.get();
        }
        if (message.isEmpty()) {
            message = key;
        }
        if (arguments == null || arguments.length == 0) {
            return message;
        }
        MessageFormat messageFormat2 = messageFormat = this.getMessageFormat(locale, message);
        synchronized (messageFormat2) {
            return messageFormat.format(arguments, new StringBuffer(), (FieldPosition)null).toString();
        }
    }

    protected MessageFormat getMessageFormat(Locale locale, String message) {
        Map map = this.messageFormatMap.computeIfAbsent(locale, l -> new ConcurrentHashMap());
        return map.computeIfAbsent(message, m4 -> new MessageFormat((String)m4, locale));
    }

    protected String getMessageFromCache(Locale locale, String key) {
        Map map = this.messageMap.computeIfAbsent(locale, l -> new ConcurrentHashMap());
        return map.computeIfAbsent(key, k -> this.resolveMessage(locale, (String)k));
    }

    protected String resolveMessage(Locale locale, String key) {
        Optional<String> optionalPattern = this.baseNames.stream().map(baseName -> this.getResourceBundle((String)baseName, locale)).filter(Objects::nonNull).map(resourceBundle -> {
            try {
                return resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst();
        return optionalPattern.orElse("");
    }

    protected Map<Locale, ResourceBundle> getResourceBundle(String baseName) {
        return this.resourceBundleMap.computeIfAbsent(baseName, key -> new ConcurrentHashMap());
    }

    protected ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return this.getResourceBundle(baseName).computeIfAbsent(locale, key -> {
            try {
                return ResourceBundle.getBundle(baseName, key);
            }
            catch (MissingResourceException e) {
                return null;
            }
        });
    }
}

