/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin.tasks;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.UUID;

public abstract class AbstractSingleStubTask
implements AdminTask {
    @Override
    public ResponseDefinition execute(Admin admin, ServeEvent serveEvent, PathParams pathParams) {
        UUID id;
        String idString = (String)pathParams.get("id");
        try {
            id = UUID.fromString(idString);
        }
        catch (IllegalArgumentException e) {
            return ResponseDefinition.badRequest(Errors.single(10, idString + " is not a valid UUID"));
        }
        SingleStubMappingResult result = admin.getStubMapping(id);
        return result.isPresent() ? this.processStubMapping(admin, serveEvent, (StubMapping)result.getItem()) : ResponseDefinition.notFound();
    }

    protected abstract ResponseDefinition processStubMapping(Admin var1, ServeEvent var2, StubMapping var3);
}

