/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.AbstractJsonValidator;
import wiremock.com.networknt.schema.AbstractKeyword;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;

public class AnnotationKeyword
extends AbstractKeyword {
    public AnnotationKeyword(String keyword) {
        super(keyword);
    }

    @Override
    public JsonValidator newValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) throws JsonSchemaException, Exception {
        return new Validator(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext, this);
    }

    private static final class Validator
    extends AbstractJsonValidator {
        public Validator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Keyword keyword) {
            super(schemaLocation, evaluationPath, keyword, schemaNode);
        }

        @Override
        public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
            Object value;
            if (this.collectAnnotations(executionContext) && (value = this.getAnnotationValue(this.getSchemaNode())) != null) {
                this.putAnnotation(executionContext, annotation -> annotation.instanceLocation(instanceLocation).value(value));
            }
            return Collections.emptySet();
        }

        protected Object getAnnotationValue(JsonNode schemaNode) {
            if (schemaNode.isTextual()) {
                return schemaNode.textValue();
            }
            if (schemaNode.isNumber()) {
                return schemaNode.numberValue();
            }
            if (schemaNode.isObject()) {
                return schemaNode;
            }
            return null;
        }
    }
}

