/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.axis2server;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.carbon.automation.extensions.servers.axis2server.Axis2ServerManager;

public class Axis2ServerExtension
extends ExecutionListenerExtension {
    private Axis2ServerManager axis2ServerManager;
    public static final String SIMPLE_STOCK_QUOTE_SERVICE = "SimpleStockQuoteService";
    public static final String SECURE_STOCK_QUOTE_SERVICE = "SecureStockQuoteService";
    public static final String LB_SERVICE_1 = "LBService1";
    public static final String SIMPLE_AXIS2_SERVICE = "Axis2Service";
    private static final Log log = LogFactory.getLog(Axis2ServerExtension.class);

    public void initiate() throws AutomationFrameworkException {
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        this.axis2ServerManager = new Axis2ServerManager();
        log.info((Object)"Starting Simple Axis2 server");
        try {
            this.axis2ServerManager.start();
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Axis2Server start failed", (Throwable)e);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ignored) {
            log.info((Object)"ignored");
        }
        log.info((Object)"Deploying services to Axis2 server");
        if (this.axis2ServerManager.isStarted()) {
            try {
                this.axis2ServerManager.deployService(SIMPLE_STOCK_QUOTE_SERVICE);
                this.axis2ServerManager.deployService(SECURE_STOCK_QUOTE_SERVICE);
                this.axis2ServerManager.deployService(LB_SERVICE_1);
                this.axis2ServerManager.deployService(SIMPLE_AXIS2_SERVICE);
            }
            catch (IOException e) {
                throw new AutomationFrameworkException("Axis2Server deploy service failed", (Throwable)e);
            }
        }
    }

    public void onExecutionFinish() throws AutomationFrameworkException {
        log.info((Object)"Stopping Simple Axis2 server");
        if (this.axis2ServerManager.isStarted()) {
            this.axis2ServerManager.stop();
        }
    }
}

