/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.axis2server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.extensions.ExtensionUtils;
import org.wso2.carbon.automation.extensions.servers.axis2server.BackendServer;

public class Axis2ServerManager
implements BackendServer {
    private static final Log log = LogFactory.getLog(Axis2ServerManager.class);
    private ConfigurationContext cfgCtx;
    private ListenerManager listenerManager;
    private boolean started;
    String repositoryPath = null;

    public Axis2ServerManager() {
        this("test_axis2_server_9000.xml");
        this.repositoryPath = System.getProperty("carbon.home") + File.separator + "samples" + File.separator + "axis2Server" + File.separator + "repository";
    }

    public Axis2ServerManager(String axis2xmlFile) {
        String newFile = axis2xmlFile + "_bk";
        this.repositoryPath = System.getProperty("carbon.home") + File.separator + "samples" + File.separator + "axis2Server" + File.separator + "repository";
        File repository = new File(this.repositoryPath);
        log.info((Object)("Using the Axis2 repository path: " + repository.getAbsolutePath()));
        try {
            this.changeConfiguration(axis2xmlFile, newFile);
            File axis2xml = this.copyResourceToFileSystem(newFile, "axis2.xml");
            if (!axis2xml.exists()) {
                log.error((Object)"Error while copying the test axis2.xml to the file system");
                return;
            }
            log.info((Object)("Loading axis2.xml from: " + axis2xml.getAbsolutePath()));
            this.cfgCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository.getAbsolutePath(), (String)axis2xml.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing the configuration context", (Throwable)e);
        }
    }

    @Override
    public void start() throws IOException {
        log.info((Object)"Starting sample Axis2 server");
        this.listenerManager = new ListenerManager();
        this.listenerManager.init(this.cfgCtx);
        this.listenerManager.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.started = true;
    }

    @Override
    public void stop() {
        log.info((Object)"Stopping sample Axis2 server");
        try {
            this.listenerManager.stop();
            this.listenerManager.destroy();
            this.cfgCtx.cleanupContexts();
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while shutting down the listener managers", (Throwable)axisFault);
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return !this.listenerManager.isStopped();
    }

    public void hotDeployArtifact(String artifact) throws IOException {
        File fOrig = new File(artifact);
        File fDest = new File(this.repositoryPath + File.separator + "services" + File.separator);
        FileUtils.copyFile((File)fOrig, (File)fDest);
    }

    public void hotUndeployArtifact(String artifact) {
        File fOrig = new File(artifact);
        FileUtils.deleteQuietly((File)fOrig);
    }

    @Override
    public void deployService(Object service) throws IOException {
        String artifactName = service + ".aar";
        File file = this.copyResourceToFileSystem(artifactName, artifactName);
        AxisServiceGroup serviceGroup = DeploymentEngine.loadServiceGroup((File)file, (ConfigurationContext)this.cfgCtx);
        this.cfgCtx.getAxisConfiguration().addServiceGroup(serviceGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeConfiguration(String file, String newFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        File config = new File(FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "AXIS2" + File.separator + "config" + File.separator + file);
        BufferedReader br = null;
        OutputStream os = null;
        try {
            File newConfig;
            if (config != null) {
                String currentLine;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(config), Charset.defaultCharset()));
                while ((currentLine = br.readLine()) != null) {
                    if (currentLine.contains("REPLACE_CK")) {
                        currentLine = currentLine.replace("REPLACE_CK", System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "wso2carbon.jks");
                    } else if (currentLine.contains("REPLACE_TS")) {
                        currentLine = currentLine.replace("REPLACE_TS", System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "client-truststore.jks");
                    }
                    sb.append(currentLine);
                }
            }
            if ((newConfig = new File(ExtensionUtils.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "AXIS2" + File.separator + "config" + File.separator + newFile)).exists()) {
                FileUtils.deleteQuietly((File)newConfig);
            }
            FileUtils.touch((File)newConfig);
            os = FileUtils.openOutputStream((File)newConfig);
            os.write(sb.toString().getBytes("UTF-8"));
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyResourceToFileSystem(String resourceName, String fileName) throws IOException {
        File file = new File(System.getProperty("basedir") + File.separator + "target" + File.separator + fileName);
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        String filePath = resourceName.contains(".aar") ? ExtensionUtils.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "AXIS2" + File.separator + "aar" + File.separator + resourceName : ExtensionUtils.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "AXIS2" + File.separator + "config" + File.separator + resourceName;
        try {
            int len;
            FileUtils.touch((File)file);
            os = FileUtils.openOutputStream((File)file);
            is = new FileInputStream(filePath);
            byte[] data = new byte[1024];
            while ((len = ((InputStream)is).read(data)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                    os.flush();
                }
            }
            catch (IOException e) {}
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {}
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyServiceToFileSystem(String resourceName, String fileName) throws IOException {
        File file = new File(System.getProperty("basedir") + File.separator + "target" + File.separator + fileName);
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file);
        }
        FileUtils.touch((File)file);
        FileOutputStream os = FileUtils.openOutputStream((File)file);
        InputStream is = null;
        try {
            is = new FileInputStream(ExtensionUtils.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "AXIS2" + File.separator + "config" + File.separator + resourceName);
            if (is != null) {
                int len;
                byte[] data = new byte[1024];
                while ((len = is.read(data)) != -1) {
                    ((OutputStream)os).write(data, 0, len);
                }
                os.flush();
            }
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (IOException e) {}
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return file;
    }
}

