/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.ftpserver;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;

public class FTPServerManager {
    private static final Log log = LogFactory.getLog(FTPServerManager.class);
    PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
    FtpServerFactory serverFactory = new FtpServerFactory();
    ListenerFactory factory = new ListenerFactory();
    boolean isRunning = false;
    int ftpPort;
    String userName;
    String password;
    String homeDirectory;
    FtpServer ftpServer;
    private Thread ftpThread = null;

    public FTPServerManager(int ftpPort, String homeDirectory, String userName, String password) {
        this.homeDirectory = homeDirectory;
        this.ftpPort = ftpPort;
        this.userName = userName;
        this.password = password;
    }

    public void startFtpServer() {
        this.factory.setPort(this.ftpPort);
        this.serverFactory.addListener("default", this.factory.createListener());
        this.serverFactory.setUserManager(this.setUser());
        this.ftpServer = this.serverFactory.createServer();
        try {
            this.ftpServer.start();
        }
        catch (FtpException e) {
            log.error((Object)("FTP server startup failed " + e.getMessage()));
        }
    }

    public UserManager setUser() {
        BaseUser user = new BaseUser();
        user.setName(this.userName);
        user.setPassword(this.password);
        user.setHomeDirectory(this.homeDirectory);
        ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
        authorities.add(new WritePermission());
        user.setAuthorities(authorities);
        UserManager um = this.userManagerFactory.createUserManager();
        try {
            um.save((User)user);
        }
        catch (FtpException e1) {
            log.error((Object)("FTP server startup failed " + e1.getMessage()));
        }
        return um;
    }

    public synchronized void startServer() {
        if (this.ftpThread == null) {
            this.ftpThread = new Thread(){

                @Override
                public void run() {
                    try {
                        FTPServerManager.this.startFtpServer();
                    }
                    catch (Exception e) {
                        log.error((Object)("FTP server startup failed " + e.getMessage()));
                    }
                }
            };
            this.ftpThread.start();
            this.isRunning = true;
        }
    }

    public void stop() {
        if (!this.isRunning) {
            log.info((Object)("Ftp server is running at the port " + this.ftpPort));
            return;
        }
        this.ftpServer.stop();
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void run() {
        try {
            this.startFtpServer();
        }
        catch (Exception e) {
            log.error((Object)("Server startup failed :" + e.getMessage()));
        }
    }
}

