/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.jmsserver.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;

public class JMSTopicMessageConsumer
implements MessageListener {
    private static final Log log = LogFactory.getLog(JMSTopicMessageConsumer.class);
    private TopicConnection connection = null;
    private TopicSession session = null;
    private TopicConnectionFactory connectionFactory = null;
    private Topic topic = null;
    private TopicSubscriber consumer = null;
    private List<String> messageList = new ArrayList<String>();

    public JMSTopicMessageConsumer(JMSBrokerConfiguration brokerConfiguration) throws NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", brokerConfiguration.getInitialNamingFactory());
        if (brokerConfiguration.getProviderURL().startsWith("amqp://")) {
            props.put("connectionfactory.TopicConnectionFactory", brokerConfiguration.getProviderURL());
        } else {
            props.setProperty("java.naming.provider.url", brokerConfiguration.getProviderURL());
        }
        InitialContext ctx = new InitialContext(props);
        this.connectionFactory = (TopicConnectionFactory)ctx.lookup("TopicConnectionFactory");
    }

    public void subscribe(String topicName) throws JMSException, NamingException {
        this.connection = this.connectionFactory.createTopicConnection();
        this.session = this.connection.createTopicSession(false, 1);
        this.topic = this.session.createTopic(topicName);
        this.consumer = this.session.createSubscriber(this.topic);
        this.consumer.setMessageListener((MessageListener)this);
        this.connection.start();
    }

    public void stopConsuming() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public List<String> getMessages() throws AutomationFrameworkException {
        return this.messageList;
    }

    public void onMessage(Message message) {
        if (message != null && message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            try {
                this.addMessage(textMessage.getText());
            }
            catch (JMSException e) {
                log.error((Object)e);
            }
        }
    }

    private synchronized void addMessage(String message) {
        this.messageList.add(message);
    }
}

