/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.sftpserver;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;

public class SFTPServer
extends Thread {
    private Log log = LogFactory.getLog(SFTPServer.class);
    private static final String USERNAME = "SFTPUser";
    private static final char[] PASSWORD = new char[]{'S', 'F', 'T', 'P', '3', '2', '1'};
    private static SshServer sshServer = SshServer.setUpDefaultServer();
    private static int port = 8005;
    private static boolean isKeepAlive = false;

    public boolean isKeepAlive() {
        return isKeepAlive;
    }

    public static void setKeepAlive(boolean keepAlive) {
        isKeepAlive = keepAlive;
    }

    public void startServer() {
        Thread thread = new Thread(new SFTPServer());
        thread.start();
    }

    @Override
    public void run() {
        sshServer.setPort(port);
        sshServer.setSubsystemFactories(Arrays.asList(new SftpSubsystem.Factory()));
        sshServer.setCommandFactory((CommandFactory)new ScpCommandFactory());
        sshServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider("hostkey.ser"));
        sshServer.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                return StringUtils.equals((CharSequence)username, (CharSequence)SFTPServer.USERNAME) && StringUtils.equals((CharSequence)password, (CharSequence)CharBuffer.wrap(PASSWORD).toString());
            }
        });
        ArrayList<SftpSubsystem.Factory> namedFactoryList = new ArrayList<SftpSubsystem.Factory>();
        namedFactoryList.add(new SftpSubsystem.Factory());
        sshServer.setSubsystemFactories(namedFactoryList);
        try {
            sshServer.start();
        }
        catch (IOException e) {
            this.log.error((Object)("Exception occurred " + e));
        }
        this.log.info((Object)("SFTP Server Stared successfully on port " + port));
        while (isKeepAlive) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                this.log.error((Object)("Exception occurred " + e));
            }
        }
    }

    public void stopServer() throws InterruptedException {
        sshServer.stop();
        this.log.info((Object)("SFTP Server Run On Port " + port + " Stopped successfully ..... "));
    }
}

