/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cache.CacheInvalidationRequestSender;
import javax.cache.event.CacheEntryListener;
import javax.cache.spi.AnnotationProvider;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.caching.impl.AnnotationProviderImpl;
import org.wso2.carbon.caching.impl.CachingProviderImpl;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.caching.impl.Util;

public class DataHolder {
    private static final Log log = LogFactory.getLog(DataHolder.class);
    private static DataHolder instance = new DataHolder();
    private DistributedMapProvider distributedMapProvider;
    private ServerConfigurationService serverConfigurationService;
    private ClusteringAgent clusteringAgent;
    private CachingProviderImpl cachingProvider = new CachingProviderImpl();
    private AnnotationProvider annotationProvider = new AnnotationProviderImpl();
    private List<CacheEntryListener> cacheEntryListeners = new ArrayList<CacheEntryListener>();
    private Map<String, CacheInvalidationRequestSender> cacheInvalidationRequestSenders = new HashMap<String, CacheInvalidationRequestSender>();
    private CacheInvalidationRequestSender configuredCacheInvalidationSender;

    public static DataHolder getInstance() {
        return instance;
    }

    private DataHolder() {
    }

    public DistributedMapProvider getDistributedMapProvider() {
        return this.distributedMapProvider;
    }

    public ServerConfigurationService getServerConfigurationService() {
        if (this.serverConfigurationService == null) {
            String msg = "Before activating javax caching  bundle, an instance of ServerConfigurationService should be in existence";
            log.error((Object)msg);
        }
        return this.serverConfigurationService;
    }

    public void setDistributedMapProvider(DistributedMapProvider distributedMapProvider) {
        this.distributedMapProvider = distributedMapProvider;
        try {
            if (distributedMapProvider != null) {
                this.cachingProvider.switchToDistributedMode();
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot setDistributedMapProvider", (Throwable)e);
        }
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setClusteringAgent(ClusteringAgent clusteringAgent) {
        this.clusteringAgent = clusteringAgent;
    }

    public CachingProviderImpl getCachingProvider() {
        return this.cachingProvider;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public ClusteringAgent getClusteringAgent() {
        return this.clusteringAgent;
    }

    public List<CacheEntryListener> getCacheEntryListeners() {
        return this.cacheEntryListeners;
    }

    public Map<String, CacheInvalidationRequestSender> getCacheInvalidationRequestSenders() {
        return this.cacheInvalidationRequestSenders;
    }

    public void addCacheInvalidationRequestSender(String name, CacheInvalidationRequestSender cacheInvalidationRequestSender) {
        this.cacheInvalidationRequestSenders.put(name, cacheInvalidationRequestSender);
        this.configuredCacheInvalidationSender = null;
    }

    public void removeCacheInvalidationRequestSender(String name) {
        this.cacheInvalidationRequestSenders.remove(name);
        this.configuredCacheInvalidationSender = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheInvalidationRequestSender getConfiguredCacheInvalidationSender() {
        if (this.configuredCacheInvalidationSender == null) {
            DataHolder dataHolder = this;
            synchronized (dataHolder) {
                if (this.configuredCacheInvalidationSender == null) {
                    this.configuredCacheInvalidationSender = Util.getCacheInvalidationRequestSender();
                }
                return this.configuredCacheInvalidationSender;
            }
        }
        return this.configuredCacheInvalidationSender;
    }
}

