/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.Map;
import javax.cache.CacheEntryInfo;
import javax.cache.CacheInvalidationRequestSender;
import javax.cache.event.CacheEntryEvent;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.caching.impl.DataHolder;
import org.wso2.carbon.caching.impl.clustering.ClusterCacheInvalidationRequestSender;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public final class Util {
    public static void checkAccess(String ownerTenantDomain, int ownerTenantId) {
        CarbonContext carbonContext = Util.getCarbonContext();
        String callerTenantDomain = carbonContext.getTenantDomain();
        if (callerTenantDomain == null) {
            throw new IllegalStateException("Caller tenant domain cannot be null");
        }
        int callerTenantId = carbonContext.getTenantId();
        if (callerTenantId == -1) {
            throw new IllegalStateException("Caller Tenant ID cannot be -1");
        }
        if (callerTenantDomain.equals("carbon.super") && callerTenantId == -1234) {
            return;
        }
        if (!callerTenantDomain.equals(ownerTenantDomain) || callerTenantId != ownerTenantId) {
            throw new SecurityException("Illegal access attempt to cache ] owned by tenant {[" + ownerTenantDomain + "],[" + ownerTenantId + "]} by tenant {[" + callerTenantDomain + "],[" + callerTenantId + "]}");
        }
    }

    private static CarbonContext getCarbonContext() {
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        if (carbonContext == null) {
            throw new IllegalStateException("CarbonContext cannot be null");
        }
        return carbonContext;
    }

    public static String getDistributedMapNameOfCache(String cacheName, String ownerTenantDomain, String cacheManagerName) {
        return "$cache.$domain[" + ownerTenantDomain + "]" + cacheManagerName + "#" + cacheName;
    }

    public static String getTenantDomain() {
        return Util.getCarbonContext().getTenantDomain();
    }

    public static long getDefaultCacheTimeout() {
        ServerConfigurationService serverConfigService = DataHolder.getInstance().getServerConfigurationService();
        if (serverConfigService != null) {
            String defaultCacheTimeoutValue = serverConfigService.getFirstProperty("Cache.DefaultCacheTimeout");
            return defaultCacheTimeoutValue == null ? 15L : Long.parseLong(defaultCacheTimeoutValue);
        }
        return 15L;
    }

    public static long getDefaultRealmCacheTimeout() {
        ServerConfigurationService serverConfigService = DataHolder.getInstance().getServerConfigurationService();
        if (serverConfigService != null) {
            String defaultCacheTimeoutValue = serverConfigService.getFirstProperty("Cache.DefaultRealmCacheTimeout");
            return StringUtils.isEmpty((String)defaultCacheTimeoutValue) ? 30L : Long.parseLong(defaultCacheTimeoutValue);
        }
        return 30L;
    }

    public static CacheEntryInfo createCacheInfo(CacheEntryEvent cacheEntryEvent) {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true);
        return new CacheEntryInfo(cacheEntryEvent.getSource().getCacheManager().getName(), cacheEntryEvent.getSource().getName(), cacheEntryEvent.getKey(), tenantDomain, tenantId);
    }

    public static CacheInvalidationRequestSender getCacheInvalidationRequestSender() {
        String cacheInvalidation;
        ServerConfigurationService serverConfigService = DataHolder.getInstance().getServerConfigurationService();
        Map<String, CacheInvalidationRequestSender> cacheInvalidationRequestSenders = DataHolder.getInstance().getCacheInvalidationRequestSenders();
        if (serverConfigService != null && StringUtils.isNotEmpty((String)(cacheInvalidation = serverConfigService.getFirstProperty("Cache.CacheInvalidationImpl"))) && cacheInvalidationRequestSenders.containsKey(cacheInvalidation)) {
            return DataHolder.getInstance().getCacheInvalidationRequestSenders().get(cacheInvalidation);
        }
        CacheInvalidationRequestSender cacheInvalidationRequestSender = cacheInvalidationRequestSenders.get("org.wso2.carbon.caching.impl.clustering.ClusterCacheInvalidationRequestSender");
        if (cacheInvalidationRequestSender != null) {
            return cacheInvalidationRequestSender;
        }
        return new ClusterCacheInvalidationRequestSender();
    }

    private Util() {
    }
}

