/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl.clustering;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.IdempotentMessage;
import org.wso2.carbon.caching.impl.CacheImpl;
import org.wso2.carbon.context.PrivilegedCarbonContext;

@IdempotentMessage
public class ClusterCacheInvalidationRequest
extends ClusteringMessage {
    private static final transient Log log = LogFactory.getLog(ClusterCacheInvalidationRequest.class);
    private static final long serialVersionUID = 94L;
    private CacheInfo cacheInfo;
    private String tenantDomain;
    private int tenantId;

    public ClusterCacheInvalidationRequest(CacheInfo cacheInfo, String tenantDomain, int tenantId) {
        this.cacheInfo = cacheInfo;
        this.tenantDomain = tenantDomain;
        this.tenantId = tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received [" + (Object)((Object)this) + "] "));
            }
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(this.tenantId);
            carbonContext.setTenantDomain(this.tenantDomain);
            CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(this.cacheInfo.cacheManagerName);
            Cache cache = cacheManager.getCache(this.cacheInfo.cacheName);
            if (cache instanceof CacheImpl) {
                if ("$__clear__all__$.".equals(this.cacheInfo.cacheKey)) {
                    ((CacheImpl)cache).removeAllLocal();
                } else {
                    ((CacheImpl)cache).removeLocal(this.cacheInfo.cacheKey);
                }
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public String toString() {
        return "ClusterCacheInvalidationRequest{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", messageId=" + this.getUuid() + ", cacheManager=" + this.cacheInfo.cacheManagerName + ", cache=" + this.cacheInfo.cacheName + ", cacheKey=" + this.cacheInfo.cacheKey + '}';
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public static class CacheInfo
    implements Serializable {
        private String cacheManagerName;
        private String cacheName;
        private Object cacheKey;

        public CacheInfo(String cacheManagerName, String cacheName, Object cacheKey) {
            this.cacheManagerName = cacheManagerName;
            this.cacheName = cacheName;
            this.cacheKey = cacheKey;
        }
    }
}

