/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl.internal;

import javax.cache.CacheInvalidationRequestSender;
import javax.cache.event.CacheEntryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.caching.impl.CachingAxisConfigurationObserver;
import org.wso2.carbon.caching.impl.DataHolder;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.caching.impl.clustering.ClusterCacheInvalidationRequestSender;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.caching.impl.internal.CachingServiceComponent", immediate=true)
public class CachingServiceComponent {
    private static final Log log = LogFactory.getLog(CachingServiceComponent.class);
    private DataHolder dataHolder = DataHolder.getInstance();

    @Activate
    protected void activate(ComponentContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CachingServiceComponent activated");
        }
        BundleContext bundleContext = ctx.getBundleContext();
        CachingAxisConfigurationObserver cachingAxisConfigurationObserver = new CachingAxisConfigurationObserver();
        bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)cachingAxisConfigurationObserver, null);
        ClusterCacheInvalidationRequestSender clusterCacheInvalidationRequestSender = new ClusterCacheInvalidationRequestSender();
        bundleContext.registerService(CacheEntryListener.class.getName(), (Object)clusterCacheInvalidationRequestSender, null);
        bundleContext.registerService(CacheInvalidationRequestSender.class.getName(), (Object)clusterCacheInvalidationRequestSender, null);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
    }

    @Reference(name="distributedMapProvider", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetDistributedMapProvider")
    protected void setDistributedMapProvider(DistributedMapProvider mapProvider) {
        this.dataHolder.setDistributedMapProvider(mapProvider);
    }

    protected void unsetDistributedMapProvider(DistributedMapProvider mapProvider) {
        this.dataHolder.setDistributedMapProvider(null);
    }

    @Reference(name="server.configuration.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.dataHolder.setServerConfigurationService(serverConfigurationService);
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.dataHolder.setServerConfigurationService(null);
    }

    @Reference(name="config.context.service", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetClusteringAgent")
    protected void setClusteringAgent(ConfigurationContextService configurationContextService) {
        this.dataHolder.setClusteringAgent(configurationContextService.getServerConfigContext().getAxisConfiguration().getClusteringAgent());
    }

    protected void unsetClusteringAgent(ConfigurationContextService configurationContextService) {
        this.dataHolder.setClusteringAgent(null);
    }

    @Reference(name="cache.entry.listener.service", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeCacheEntryListener")
    protected void addCacheEntryListener(CacheEntryListener cacheEntryListener) {
        this.dataHolder.getCacheEntryListeners().add(cacheEntryListener);
    }

    protected void removeCacheEntryListener(CacheEntryListener cacheEntryListener) {
        this.dataHolder.getCacheEntryListeners().remove(cacheEntryListener);
    }

    @Reference(name="cache.invalidation.request.sender.service", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeCacheInvalidationRequestSender")
    protected void addCacheInvalidationRequestSender(CacheInvalidationRequestSender cacheInvalidationRequestSender) {
        this.dataHolder.addCacheInvalidationRequestSender(cacheInvalidationRequestSender.getClass().getName(), cacheInvalidationRequestSender);
    }

    protected void removeCacheInvalidationRequestSender(CacheInvalidationRequestSender cacheInvalidationRequestSender) {
        this.dataHolder.removeCacheInvalidationRequestSender(cacheInvalidationRequestSender.getClass().getName());
    }
}

