/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.inbound.InboundRequestProcessor;
import org.apache.synapse.startup.quartz.StartUpController;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskManager;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.common.InboundRunner;
import org.wso2.carbon.inbound.endpoint.common.InboundTask;
import org.wso2.carbon.inbound.endpoint.osgi.service.ServiceReferenceHolder;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointsDataStore;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSTask;
import org.wso2.carbon.mediation.ntask.NTaskTaskManager;
import org.wso2.carbon.ntask.core.impl.LocalTaskActionListener;

public abstract class InboundRequestProcessorImpl
implements InboundRequestProcessor {
    protected SynapseEnvironment synapseEnvironment;
    protected long interval;
    protected String name;
    protected boolean coordination;
    private List<StartUpController> startUpControllersList = new ArrayList<StartUpController>();
    private HashMap<Thread, InboundRunner> inboundRunnersThreadsMap = new HashMap();
    private static final Log log = LogFactory.getLog(InboundRequestProcessorImpl.class);
    private InboundEndpointsDataStore dataStore = InboundEndpointsDataStore.getInstance();
    protected static final String COMMON_ENDPOINT_POSTFIX = "--SYNAPSE_INBOUND_ENDPOINT";

    protected void start(InboundTask task, String endpointPostfix) {
        log.info((Object)("Starting the inbound endpoint " + this.name + ", with coordination " + this.coordination + ". Interval : " + this.interval + ". Type : " + endpointPostfix));
        if (this.coordination) {
            try {
                TaskManager taskManagerImpl;
                TaskDescription taskDescription = new TaskDescription();
                taskDescription.setName(this.name + "-" + endpointPostfix);
                taskDescription.setTaskGroup(endpointPostfix);
                if (this.interval < 1000L) {
                    taskDescription.setInterval(1000L);
                } else {
                    taskDescription.setInterval(this.interval);
                }
                taskDescription.setIntervalInMs(true);
                taskDescription.addResource("Instance", (Object)task);
                taskDescription.addResource("ClassName", (Object)task.getClass().getName());
                StartUpController startUpController = new StartUpController();
                startUpController.setTaskDescription(taskDescription);
                startUpController.init(this.synapseEnvironment);
                this.startUpControllersList.add(startUpController);
                if (task instanceof JMSTask && (taskManagerImpl = this.synapseEnvironment.getTaskManager().getTaskManagerImpl()) instanceof NTaskTaskManager) {
                    ((NTaskTaskManager)taskManagerImpl).registerListener((LocalTaskActionListener)((JMSTask)task), taskDescription.getName());
                }
            }
            catch (Exception e) {
                log.error((Object)("Error starting the inbound endpoint " + this.name + ". Unable to schedule the task. " + e.getLocalizedMessage()), (Throwable)e);
            }
        } else {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            int tenantId = carbonContext.getTenantId();
            String tenantDomain = null;
            if (tenantId != -1234 && !this.dataStore.isPollingEndpointRegistered(tenantDomain = carbonContext.getTenantDomain(), this.name)) {
                this.dataStore.registerPollingingEndpoint(tenantDomain, this.name);
            }
            if (InboundRequestProcessorImpl.isPinnedServerEnabled(task.getInboundProperties())) {
                if (this.isPinnedServer(task.getInboundProperties())) {
                    this.startInboundRunnerThread(task, tenantDomain, true);
                } else {
                    log.info((Object)("Inbound Endpoint " + this.name + " not started as it is not pinned to this server"));
                }
            } else {
                this.startInboundRunnerThread(task, tenantDomain, false);
            }
        }
    }

    private void startInboundRunnerThread(InboundTask task, String tenantDomain, boolean mgrOverride) {
        InboundRunner inboundRunner = new InboundRunner(task, this.interval, tenantDomain, mgrOverride);
        Thread runningThread = new Thread(inboundRunner);
        this.inboundRunnersThreadsMap.put(runningThread, inboundRunner);
        runningThread.start();
    }

    public void destroy() {
        log.info((Object)("Inbound endpoint " + this.name + " stopping."));
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        int tenantId = carbonContext.getTenantId();
        if (tenantId != -1234) {
            this.dataStore.unregisterPollingEndpoint(carbonContext.getTenantDomain(), this.name);
        }
        if (!this.startUpControllersList.isEmpty()) {
            for (StartUpController sc : this.startUpControllersList) {
                sc.destroy();
            }
            this.startUpControllersList.clear();
        } else if (!this.inboundRunnersThreadsMap.isEmpty()) {
            for (Map.Entry<Thread, InboundRunner> entry : this.inboundRunnersThreadsMap.entrySet()) {
                Thread thread = entry.getKey();
                InboundRunner inboundRunner = entry.getValue();
                inboundRunner.terminate();
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    thread.interrupt();
                    log.error((Object)"Error while stopping the inbound thread.");
                }
            }
            this.inboundRunnersThreadsMap.clear();
        }
    }

    protected static boolean isPinnedServerEnabled(Properties inboundProperties) {
        return inboundProperties != null && inboundProperties.getProperty("pinnedServers") != null;
    }

    protected boolean isPinnedServer(Properties inboundProperties) {
        String pinnedServersValue;
        List<String> pinnedServers;
        String thisServerName = System.getProperty("pinServerName", null);
        if (!(thisServerName != null && !"".equals(thisServerName) || (thisServerName = InboundRequestProcessorImpl.getAxis2ParameterValue(ServiceReferenceHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration(), "SynapseConfig.ServerName")) != null && !"".equals(thisServerName) || (thisServerName = System.getProperty("SynapseServerName", null)) != null && !"".equals(thisServerName) || (thisServerName = this.getServerHost()) != null && !"".equals(thisServerName))) {
            thisServerName = "localhost";
        }
        return (pinnedServers = this.getPinnedServers(pinnedServersValue = inboundProperties.getProperty("pinnedServers", null))) != null && !pinnedServers.isEmpty() && pinnedServers.contains(thisServerName);
    }

    private static String getAxis2ParameterValue(AxisConfiguration axisConfiguration, String paramKey) {
        Parameter parameter = axisConfiguration.getParameter(paramKey);
        if (parameter == null) {
            return null;
        }
        Object value = parameter.getValue();
        if (value != null && value instanceof String) {
            return (String)parameter.getValue();
        }
        return null;
    }

    private List<String> getPinnedServers(String pinnedServersValue) {
        StringTokenizer st = new StringTokenizer(pinnedServersValue, " ,");
        ArrayList<String> pinnedServersList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0) continue;
            pinnedServersList.add(token);
        }
        return pinnedServersList;
    }

    private String getServerHost() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr != null) {
                return addr.getHostName();
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Unable to get the hostName or IP address of the server", (Throwable)e);
        }
        return null;
    }
}

