/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.internal.http.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.transport.passthru.core.ssl.SSLConfiguration;
import org.wso2.carbon.inbound.endpoint.internal.http.api.InternalAPI;
import org.wso2.carbon.inbound.endpoint.internal.http.api.InternalAPIHandler;
import org.wso2.carbon.inbound.endpoint.persistence.PersistenceUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class ConfigurationLoader {
    private static Log log = LogFactory.getLog(ConfigurationLoader.class);
    private static final QName ROOT_Q = new QName("internalApis");
    private static final QName API_Q = new QName("api");
    private static final QName CLASS_Q = new QName("class");
    private static final QName NAME_ATT = new QName("name");
    private static final QName PROTOCOL_Q = new QName("protocol");
    private static final QName HANDLERS_Q = new QName("handlers");
    private static final String APIS = "apis";
    private static final String SSL_CONFIG = "sslConfig";
    private static final String KEYSTORE_ATT = "keystore";
    private static final String TRUSTSTORE_ATT = "truststore";
    private static final String SSL_VERIFY_CLIENT_ATT = "sslVerifyClient";
    private static final String SSL_PROTOCOL_ATT = "sslProtocol";
    private static final String HTTPS_PROTOCOLS_ATT = "httpsProtocols";
    private static final String CERTIFICATE_REVOCATION_VERIFIER_ATT = "certificateRevocationVerifier";
    private static final String PREFERRED_CIPHERS_ATT = "preferredCiphers";
    private static SSLConfiguration sslConfiguration;
    private static boolean sslConfiguredSuccessfully;
    private static List<InternalAPI> internalHttpApiList;
    private static List<InternalAPI> internalHttpsApiList;
    private static String internalInboundHttpPortProperty;
    private static String internalInboundHttpsPortProperty;
    private static final int PORT_OFFSET;

    public static void loadInternalApis(String apiFilePath) {
        OMElement apiConfig = MiscellaneousUtil.loadXMLConfig((String)apiFilePath);
        if (apiConfig != null) {
            OMElement apis;
            Iterator apiList;
            Iterator apiIterator;
            if (!ROOT_Q.equals(apiConfig.getQName())) {
                ConfigurationLoader.handleException("Invalid internal api configuration file");
            }
            if ((apiIterator = apiConfig.getChildrenWithLocalName(APIS)).hasNext() && (apiList = (apis = (OMElement)apiIterator.next()).getChildrenWithName(API_Q)) != null) {
                Iterator sslConfigIterator = apiConfig.getChildrenWithLocalName(SSL_CONFIG);
                if (sslConfigIterator.hasNext()) {
                    sslConfiguration = ConfigurationLoader.setSslConfig((OMElement)sslConfigIterator.next());
                }
                while (apiList.hasNext()) {
                    OMElement apiElement = (OMElement)apiList.next();
                    String name = null;
                    if (apiElement.getAttribute(NAME_ATT) != null) {
                        name = apiElement.getAttributeValue(NAME_ATT);
                        if (name == null || name.isEmpty()) {
                            ConfigurationLoader.handleException("Name not specified in one or more handlers");
                        }
                        if (!Boolean.parseBoolean(System.getProperty("enable" + name))) {
                            continue;
                        }
                    } else {
                        ConfigurationLoader.handleException("Name not defined in one or more handlers");
                    }
                    if (apiElement.getAttribute(CLASS_Q) != null) {
                        String className = apiElement.getAttributeValue(CLASS_Q);
                        if (!className.isEmpty()) {
                            InternalAPI internalApi = ConfigurationLoader.createApi(className);
                            internalApi.setName(name);
                            ConfigurationLoader.populateHandlers(apiElement, internalApi);
                            if (apiElement.getAttribute(PROTOCOL_Q) != null) {
                                String protocols = apiElement.getAttributeValue(PROTOCOL_Q);
                                if (!protocols.isEmpty()) {
                                    String[] protocolList;
                                    String[] stringArray = protocolList = protocols.split(" ");
                                    int n = stringArray.length;
                                    block9: for (int i = 0; i < n; ++i) {
                                        String protocol;
                                        switch (protocol = stringArray[i]) {
                                            case "http": {
                                                internalHttpApiList.add(internalApi);
                                                continue block9;
                                            }
                                            case "https": {
                                                internalHttpsApiList.add(internalApi);
                                                continue block9;
                                            }
                                            default: {
                                                ConfigurationLoader.handleException("Unsupported Protocol found for Internal API");
                                            }
                                        }
                                    }
                                    continue;
                                }
                                log.warn((Object)("No protocol specified for InternalAPI : " + name + ". Hence it will not be enabled."));
                                continue;
                            }
                            log.warn((Object)("Protocol not defined for InternalAPI : " + name + ". Hence it will not be enabled."));
                            continue;
                        }
                        ConfigurationLoader.handleException("Class name is null for Internal InternalAPI name : " + name);
                        continue;
                    }
                    ConfigurationLoader.handleException("Class name not defined for Internal InternalAPI named : " + name);
                }
            }
        }
    }

    private static void populateHandlers(OMElement apiElement, InternalAPI api) {
        ArrayList<InternalAPIHandler> handlerList = new ArrayList<InternalAPIHandler>();
        OMElement handlersElement = apiElement.getFirstChildWithName(HANDLERS_Q);
        if (handlersElement != null) {
            Iterator handlers = handlersElement.getChildElements();
            while (handlers.hasNext()) {
                OMElement handlerElement = (OMElement)handlers.next();
                if (handlerElement.getAttribute(NAME_ATT) != null) {
                    String handlerName = handlerElement.getAttributeValue(NAME_ATT);
                    if (handlerElement.getAttribute(CLASS_Q) != null) {
                        String handlerClass = handlerElement.getAttributeValue(CLASS_Q);
                        InternalAPIHandler handler = ConfigurationLoader.createHandler(handlerClass);
                        handler.setName(handlerName);
                        handlerList.add(handler);
                        continue;
                    }
                    ConfigurationLoader.handleException("Class attribute is not defined in " + handlerElement.getAttributeValue(NAME_ATT));
                    continue;
                }
                ConfigurationLoader.handleException("Name not defined in one or more handlers");
            }
        }
        api.setHandlers(handlerList);
    }

    private static InternalAPIHandler createHandler(String classFQName) {
        try {
            Object obj = Class.forName(classFQName).newInstance();
            if (obj instanceof InternalAPIHandler) {
                return (InternalAPIHandler)obj;
            }
            throw new SynapseException("Error creating Internal InternalAPIHandler. The InternalAPIHandler should be of type InternalAPIHandler");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SynapseException("Error creating Internal InternalAPIHandler for class name : " + classFQName, (Throwable)e);
        }
    }

    private static InternalAPI createApi(String classFQName) {
        try {
            Object obj = Class.forName(classFQName).newInstance();
            if (obj instanceof InternalAPI) {
                return (InternalAPI)obj;
            }
            throw new SynapseException("Error creating Internal InternalAPI. The InternalAPI should be of type InternalAPI");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SynapseException("Error creating Internal InternalAPI for class name : " + classFQName, (Throwable)e);
        }
    }

    public static int getInternalInboundHttpPort() {
        return ConfigurationLoader.getPort("internal.http.api.port", internalInboundHttpPortProperty, 9191);
    }

    public static int getInternalInboundHttpsPort() {
        return ConfigurationLoader.getPort("internal.https.api.port", internalInboundHttpsPortProperty, 9154);
    }

    private static int getPort(String propertyName, String portProperty, int defaultPort) {
        int port = defaultPort;
        if (portProperty != null) {
            try {
                port = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException ex) {
                ConfigurationLoader.handleException(propertyName + " is not in proper format", ex);
            }
        }
        return port + PORT_OFFSET;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception ex) {
        log.error((Object)msg, (Throwable)ex);
        throw new SynapseException(msg, (Throwable)ex);
    }

    public static SSLConfiguration getSslConfiguration() {
        return sslConfiguration;
    }

    public static List<InternalAPI> getHttpInternalApis() {
        return internalHttpApiList;
    }

    public static List<InternalAPI> getHttpsInternalApis() {
        return internalHttpsApiList;
    }

    public static boolean isSslConfiguredSuccessfully() {
        return sslConfiguredSuccessfully;
    }

    public static boolean isInternalApiEnabled() {
        File synapseProperties = Paths.get(CarbonUtils.getCarbonConfigDirPath(), "synapse.properties").toFile();
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(synapseProperties);){
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            ConfigurationLoader.handleException("synapse.properties file not found", e);
        }
        catch (IOException e) {
            ConfigurationLoader.handleException("Error while reading synapse.properties file", e);
        }
        String internalInboundEnabledProperty = properties.getProperty("internal.http.api.enabled");
        if (internalInboundEnabledProperty == null) {
            return false;
        }
        boolean isEnabled = Boolean.parseBoolean(internalInboundEnabledProperty);
        if (isEnabled) {
            internalInboundHttpPortProperty = properties.getProperty("internal.http.api.port");
            internalInboundHttpsPortProperty = properties.getProperty("internal.https.api.port");
        }
        return isEnabled;
    }

    private static SSLConfiguration setSslConfig(OMElement sslConfig) {
        Iterator iterator = sslConfig.getChildElements();
        String trustStore = null;
        String keyStore = null;
        String clientAuth = null;
        String httpsProtocols = null;
        String revocationVerifier = null;
        String sslProtocol = null;
        String prefferedCiphers = null;
        block22: while (iterator.hasNext()) {
            String value;
            OMElement parameter = (OMElement)iterator.next();
            String attributeName = parameter.getAttributeValue(NAME_ATT);
            if (parameter.getFirstElement() != null) {
                value = parameter.getFirstElement().toString();
                switch (attributeName) {
                    case "keystore": {
                        keyStore = value;
                        break;
                    }
                    case "truststore": {
                        trustStore = value;
                        break;
                    }
                    case "certificateRevocationVerifier": {
                        revocationVerifier = value;
                        break;
                    }
                    default: {
                        ConfigurationLoader.handleException("Invalid parameter found for internal API ssl configuration");
                        break;
                    }
                }
                continue;
            }
            value = parameter.getText();
            switch (attributeName) {
                case "sslProtocol": {
                    sslProtocol = value;
                    continue block22;
                }
                case "preferredCiphers": {
                    prefferedCiphers = value;
                    continue block22;
                }
                case "httpsProtocols": {
                    httpsProtocols = value;
                    continue block22;
                }
                case "sslVerifyClient": {
                    clientAuth = value;
                    continue block22;
                }
            }
            ConfigurationLoader.handleException("Invalid parameter found for internal API ssl configuration");
        }
        if (keyStore == null) {
            log.error((Object)"Keystore must be specified to configure internal Https Api.");
        } else {
            sslConfiguredSuccessfully = true;
        }
        return new SSLConfiguration(keyStore, trustStore, clientAuth, httpsProtocols, revocationVerifier, sslProtocol, prefferedCiphers);
    }

    public static void destroy() {
        internalHttpApiList = new ArrayList<InternalAPI>();
        internalHttpsApiList = new ArrayList<InternalAPI>();
    }

    static {
        internalHttpApiList = new ArrayList<InternalAPI>();
        internalHttpsApiList = new ArrayList<InternalAPI>();
        PORT_OFFSET = PersistenceUtils.getPortOffset();
    }
}

