/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.codec;

import ca.uhn.hl7v2.HL7Exception;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.context.MLLPContext;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.MLLPConstants;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.MLLProtocolException;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.util.HL7MessageUtils;

public class HL7Codec {
    private static final Log log = LogFactory.getLog(HL7Codec.class);
    public static final int READ_HEADER = 0;
    public static final int READ_CONTENT = 1;
    public static final int READ_TRAILER = 2;
    public static final int READ_COMPLETE = 3;
    public static final int WRITE_HEADER = 4;
    public static final int WRITE_CONTENT = 5;
    public static final int WRITE_TRAILER = 6;
    public static final int WRITE_COMPLETE = 7;
    private CharsetDecoder charsetDecoder;
    private volatile int state = 0;
    private volatile boolean firstTrailingCharacterFound = false;
    private volatile boolean lastTrailingCharacterFound = false;
    private volatile boolean addMissingCharacter = false;
    private int responseReadPosition = 0;
    private byte[] responseBytes = null;

    public HL7Codec() {
        this.charsetDecoder = MLLPConstants.UTF8_CHARSET.newDecoder();
    }

    public HL7Codec(CharsetDecoder charsetDecoder) {
        this.setCharsetDecoder(charsetDecoder);
    }

    public int decode(ByteBuffer dst, MLLPContext context) throws IOException, MLLProtocolException, HL7Exception {
        if (this.state >= 3 || dst.position() < 0) {
            return -1;
        }
        if (this.state == 0) {
            if (dst.get(0) == MLLPConstants.HL7_HEADER[0]) {
                dst.position(1);
                this.state = 1;
            } else {
                throw new MLLProtocolException("Could not find header in incoming message.");
            }
        }
        if (this.state == 1) {
            int trailerIndex = this.findTrailer(dst);
            if (trailerIndex > -1) {
                dst.limit(trailerIndex);
            }
            if (this.lastTrailingCharacterFound) {
                this.state = 2;
                this.lastTrailingCharacterFound = false;
                this.firstTrailingCharacterFound = false;
            }
            if (this.addMissingCharacter) {
                context.getRequestBuffer().append(MLLPConstants.HL7_TRAILER[0]);
                this.addMissingCharacter = false;
            }
            context.getRequestBuffer().append(this.charsetDecoder.decode(dst).toString());
        }
        if (this.state == 2) {
            this.state = 3;
            try {
                if (context.isPreProcess()) {
                    context.setHl7Message(HL7MessageUtils.parse(context.getRequestBuffer().toString(), context.getPreProcessParser()));
                } else {
                    context.setHl7Message(HL7MessageUtils.parse(context.getRequestBuffer().toString(), context.isValidateMessage()));
                }
                context.getRequestBuffer().setLength(0);
            }
            catch (HL7Exception e) {
                log.error((Object)("Error while parsing request message: " + context.getRequestBuffer()));
                throw e;
            }
        }
        return 0;
    }

    private int findTrailer(ByteBuffer dst) {
        if (this.firstTrailingCharacterFound) {
            this.firstTrailingCharacterFound = false;
            if (dst.get(0) == MLLPConstants.HL7_TRAILER[1]) {
                this.lastTrailingCharacterFound = true;
                return 0;
            }
            this.addMissingCharacter = true;
        }
        for (int i = 0; i < dst.limit(); ++i) {
            if (dst.get(i) != MLLPConstants.HL7_TRAILER[0]) continue;
            if (i + 1 >= dst.limit()) {
                this.firstTrailingCharacterFound = true;
                return i - 1;
            }
            if (dst.get(i + 1) != MLLPConstants.HL7_TRAILER[1]) continue;
            this.lastTrailingCharacterFound = true;
            return i - 1 < 0 ? 0 : i - 1;
        }
        return -1;
    }

    public int encode(ByteBuffer outBuf, MLLPContext context) throws HL7Exception, IOException {
        if (this.state < 3) {
            return 0;
        }
        if (this.state == 3) {
            if ((context.isAutoAck() || context.isApplicationAck()) && !context.isNackMode()) {
                this.responseBytes = context.getHl7Message().generateACK().encode().getBytes(this.charsetDecoder.charset());
                context.setApplicationAck(false);
            } else {
                this.responseBytes = context.getHl7Message().encode().getBytes(this.charsetDecoder.charset());
            }
            this.state = 4;
        }
        if (this.state >= 4) {
            return this.fillBuffer(outBuf, this.responseBytes);
        }
        return 0;
    }

    private int fillBuffer(ByteBuffer byteBuffer, byte[] responseBytes) {
        if (responseBytes == null) {
            return 0;
        }
        int count = 0;
        int headerPosition = 0;
        if (this.state == 4) {
            byteBuffer.put(MLLPConstants.HL7_HEADER[0]);
            headerPosition = 1;
            this.state = 5;
        }
        int MAX = byteBuffer.capacity();
        if (byteBuffer.capacity() - (responseBytes.length - this.responseReadPosition + headerPosition) > 0) {
            MAX = responseBytes.length - this.responseReadPosition + headerPosition;
        }
        for (int i = this.responseReadPosition; i < MAX + this.responseReadPosition - headerPosition; ++i) {
            ++count;
            byte b = responseBytes[i];
            byteBuffer.put(b);
        }
        this.responseReadPosition += count;
        if (this.responseReadPosition == responseBytes.length) {
            this.state = 6;
            this.responseReadPosition = 0;
        }
        byteBuffer.flip();
        return count;
    }

    public boolean isReadComplete() {
        return this.state >= 3;
    }

    public boolean isWriteTrailer() {
        return this.state == 6;
    }

    public boolean isWriteComplete() {
        return this.state == 7;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public CharsetDecoder getCharsetDecoder() {
        return this.charsetDecoder;
    }

    private void setCharsetDecoder(CharsetDecoder charsetDecoder) {
        this.charsetDecoder = charsetDecoder;
    }
}

