/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.core;

import ca.uhn.hl7v2.HL7Exception;
import java.nio.charset.CharsetDecoder;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundResponseSender;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.context.MLLPContext;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.CallableTask;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.util.HL7ExecutorServiceFactory;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.util.HL7MessageUtils;

public class HL7Processor
implements InboundResponseSender {
    private static final Log log = LogFactory.getLog(HL7Processor.class);
    private ScheduledExecutorService executorService = HL7ExecutorServiceFactory.getExecutorService();
    private Map<String, Object> parameters;
    private InboundProcessorParams params;
    private String inSequence;
    private String onErrorSequence;
    private boolean autoAck = true;
    private int timeOut;

    public HL7Processor(Map<String, Object> parameters) {
        this.parameters = parameters;
        this.params = (InboundProcessorParams)parameters.get("HL7_INBOUND_PARAMS");
        this.inSequence = this.params.getInjectingSeq();
        this.onErrorSequence = this.params.getOnErrorSeq();
        if (this.params.getProperties().getProperty("inbound.hl7.AutoAck").equals("false")) {
            this.autoAck = false;
        }
        this.timeOut = HL7MessageUtils.getInt("inbound.hl7.TimeOut", this.params);
    }

    public void processRequest(MLLPContext mllpContext) throws Exception {
        org.apache.synapse.MessageContext synCtx;
        mllpContext.setRequestTime(System.currentTimeMillis());
        try {
            synCtx = HL7MessageUtils.createSynapseMessageContext(mllpContext.getHl7Message(), this.params);
        }
        catch (HL7Exception e) {
            this.handleException(mllpContext, e.getMessage());
            return;
        }
        catch (AxisFault e) {
            this.handleException(mllpContext, e.getMessage());
            return;
        }
        mllpContext.setMessageId(synCtx.getMessageID());
        synCtx.setProperty("inbound.endpoint.name", (Object)this.params.getName());
        synCtx.setProperty("ARTIFACT_NAME", (Object)("inboundendpoint" + this.params.getName()));
        synCtx.setProperty("isInbound", (Object)true);
        InboundEndpoint inboundEndpoint = synCtx.getConfiguration().getInboundEndpoint(this.params.getName());
        CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
        synCtx.setProperty("HL7_INBOUND_MSG_ID", (Object)synCtx.getMessageID());
        if (!this.autoAck) {
            synCtx.setProperty("inbound-response-worker", (Object)this);
            synCtx.setProperty("HL7_MLLP_CONTEXT", (Object)mllpContext);
        }
        this.addProperties(synCtx, mllpContext);
        SequenceMediator injectSeq = (SequenceMediator)synCtx.getEnvironment().getSynapseConfiguration().getSequence(this.inSequence);
        if (injectSeq == null) {
            log.error((Object)("Could not find inbound sequence '" + this.inSequence + "'."));
            this.handleException(mllpContext, "Could not find inbound sequence.");
            return;
        }
        if (!injectSeq.isInitialized()) {
            injectSeq.init(synCtx.getEnvironment());
        }
        injectSeq.setErrorHandler(this.onErrorSequence);
        if (!this.autoAck && this.timeOut > 0) {
            this.executorService.schedule(new TimeoutHandler(mllpContext, synCtx.getMessageID()), (long)this.timeOut, TimeUnit.MILLISECONDS);
        }
        CallableTask task = new CallableTask(synCtx, injectSeq);
        this.executorService.submit(task);
    }

    public void processError(MLLPContext mllpContext, Exception ex) {
        org.apache.synapse.MessageContext synCtx;
        mllpContext.setRequestTime(System.currentTimeMillis());
        try {
            synCtx = mllpContext.getRequestBuffer() != null ? HL7MessageUtils.createErrorMessageContext(mllpContext.getRequestBuffer().toString(), ex, this.params) : HL7MessageUtils.createErrorMessageContext("The message received is not parseable", ex, this.params);
        }
        catch (HL7Exception e) {
            this.handleException(mllpContext, e.getMessage());
            return;
        }
        catch (AxisFault e) {
            this.handleException(mllpContext, e.getMessage());
            return;
        }
        mllpContext.setMessageId(synCtx.getMessageID());
        synCtx.setProperty("inbound.endpoint.name", (Object)this.params.getName());
        synCtx.setProperty("ARTIFACT_NAME", (Object)("inboundendpoint" + this.params.getName()));
        synCtx.setProperty("isInbound", (Object)true);
        InboundEndpoint inboundEndpoint = synCtx.getConfiguration().getInboundEndpoint(this.params.getName());
        CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
        synCtx.setProperty("HL7_INBOUND_MSG_ID", (Object)synCtx.getMessageID());
        if (!this.autoAck) {
            synCtx.setProperty("inbound-response-worker", (Object)this);
            synCtx.setProperty("HL7_MLLP_CONTEXT", (Object)mllpContext);
        }
        this.addProperties(synCtx, mllpContext);
        SequenceMediator injectSeq = (SequenceMediator)synCtx.getEnvironment().getSynapseConfiguration().getSequence(this.onErrorSequence);
        if (injectSeq == null) {
            log.error((Object)("Could not find inbound error sequence '" + this.onErrorSequence + "'."));
            this.handleException(mllpContext, "Could not find inbound error sequence.");
            return;
        }
        if (!injectSeq.isInitialized()) {
            injectSeq.init(synCtx.getEnvironment());
        }
        if (!this.autoAck && this.timeOut > 0) {
            this.executorService.schedule(new TimeoutHandler(mllpContext, synCtx.getMessageID()), (long)this.timeOut, TimeUnit.MILLISECONDS);
        }
        CallableTask task = new CallableTask(synCtx, injectSeq);
        this.executorService.submit(task);
    }

    private void addProperties(org.apache.synapse.MessageContext synCtx, MLLPContext context) {
        MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        axis2MsgCtx.setProperty("HL7_MESSAGE_OBJECT", (Object)context.getHl7Message());
        if (this.params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages") != null) {
            axis2MsgCtx.setProperty("transport.hl7.BuildInvalidMessages", (Object)Boolean.valueOf(this.params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages")));
        }
        if (this.params.getProperties().getProperty("inbound.hl7.PassThroughInvalidMessages") != null) {
            axis2MsgCtx.setProperty("transport.hl7.PassThroughInvalidMessages", (Object)Boolean.valueOf(this.params.getProperties().getProperty("inbound.hl7.PassThroughInvalidMessages")));
        }
        if (this.parameters.get("HL7_CHARSET_DECODER") != null) {
            axis2MsgCtx.setProperty("HL7_MESSAGE_CHARSET", (Object)((CharsetDecoder)this.parameters.get("HL7_CHARSET_DECODER")).charset().displayName());
        }
    }

    public Map<String, Object> getInboundParameterMap() {
        return this.parameters;
    }

    public void sendBack(org.apache.synapse.MessageContext messageContext) {
        MLLPContext mllpContext = (MLLPContext)messageContext.getProperty("HL7_MLLP_CONTEXT");
        this.sendBack(messageContext, mllpContext);
    }

    private void sendBack(org.apache.synapse.MessageContext messageContext, MLLPContext mllpContext) {
        if (messageContext.getProperty("HL7_INBOUND_MSG_ID") != null && !mllpContext.getMessageId().equals(messageContext.getProperty("HL7_INBOUND_MSG_ID"))) {
            log.warn((Object)"Response ID does not match request ID. Response may have been received after timeout.");
            return;
        }
        try {
            if ((String)messageContext.getProperty("HL7_RESULT_MODE") != null && ((String)messageContext.getProperty("HL7_RESULT_MODE")).equals("NACK")) {
                String nackMessage = (String)messageContext.getProperty("HL7_NACK_MESSAGE");
                mllpContext.setNackMode(true);
                mllpContext.setHl7Message(HL7MessageUtils.createNack(mllpContext.getHl7Message(), nackMessage));
            } else if (messageContext.getProperty("HL7_APPLICATION_ACK") != null && messageContext.getProperty("HL7_APPLICATION_ACK").equals("true")) {
                mllpContext.setApplicationAck(true);
            } else {
                mllpContext.setHl7Message(HL7MessageUtils.payloadToHL7Message(messageContext, this.params));
            }
            mllpContext.requestOutput();
        }
        catch (NoSuchElementException e) {
            log.error((Object)"Could not find HL7 response in required XML format. Please ensure XML payload contains response inside message tags with namespace http://wso2.org/hl7.", (Throwable)e);
            this.handleException(mllpContext, "Error while generating HL7 response. Not in required format.");
        }
        catch (HL7Exception e) {
            log.error((Object)"Error while generating HL7 ACK response from payload.", (Throwable)e);
            this.handleException(mllpContext, "Error while generating ACK from payload.");
        }
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    private void handleException(MLLPContext mllpContext, String msg) {
        if (mllpContext.isAutoAck()) {
            try {
                mllpContext.setNackMode(true);
                mllpContext.setHl7Message(HL7MessageUtils.createNack(mllpContext.getHl7Message(), msg));
                mllpContext.requestOutput();
            }
            catch (HL7Exception e) {
                log.error((Object)"Error while generating NACK response.", (Throwable)e);
            }
        } else {
            this.processError(mllpContext, new Exception(msg));
        }
    }

    private class TimeoutHandler
    implements Runnable {
        private MLLPContext context;
        private String messageId;

        public TimeoutHandler(MLLPContext context, String messageId) {
            this.context = context;
            this.messageId = messageId;
        }

        @Override
        public void run() {
            if (this.messageId.equals(this.context.getMessageId())) {
                try {
                    log.warn((Object)"Timed out while waiting for HL7 Response to be generated.");
                    this.context.setHl7Message(HL7MessageUtils.createNack(this.context.getHl7Message(), "Timed out while waiting for HL7 Response to be generated."));
                    this.context.setMessageId("TIMEOUT");
                    this.context.requestOutput();
                }
                catch (HL7Exception e) {
                    log.error((Object)"Could not generate timeout NACK response.", (Throwable)e);
                }
            }
        }
    }
}

