/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.util.HL7Configuration;

public class HL7ExecutorServiceFactory {
    private static ScheduledExecutorService executorService = Executors.newScheduledThreadPool(HL7Configuration.getInstance().getIntProperty("worker_threads_core", 100), HL7WorkerThreadFactory.getInstance());

    public static ScheduledExecutorService getExecutorService() {
        return executorService;
    }

    private static class HL7WorkerThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        private static HL7WorkerThreadFactory instance = new HL7WorkerThreadFactory();

        private HL7WorkerThreadFactory() {
            this.group = new ThreadGroup("HL7-inbound-thread-group");
            this.namePrefix = "HL7-inbound-worker-";
        }

        public static HL7WorkerThreadFactory getInstance() {
            return instance;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

