/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.httpwebsocket.management;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.transport.netty.api.HttpWebSocketInboundEndpointHandler;
import org.apache.synapse.transport.netty.api.config.HttpWebSocketInboundEndpointConfiguration;
import org.apache.synapse.transport.netty.api.config.SSLConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.common.AbstractInboundEndpointManager;
import org.wso2.carbon.inbound.endpoint.inboundfactory.InboundRequestProcessorFactoryImpl;
import org.wso2.carbon.inbound.endpoint.osgi.service.ServiceReferenceHolder;

public class HttpWebsocketEndpointManager
extends AbstractInboundEndpointManager {
    private static final Log LOGGER = LogFactory.getLog(HttpWebsocketEndpointManager.class);
    private static final HttpWebsocketEndpointManager instance = new HttpWebsocketEndpointManager();

    public static HttpWebsocketEndpointManager getInstance() {
        return instance;
    }

    @Override
    public boolean startEndpoint(int port, String name, InboundProcessorParams inboundParameters) {
        if (this.handleExistingEndpointOnSamePort(port, name)) {
            return true;
        }
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        this.dataStore.registerListeningEndpoint(port, tenantDomain, InboundRequestProcessorFactoryImpl.Protocols.httpws.toString(), name, inboundParameters);
        boolean start = this.startListener(port, name, inboundParameters);
        if (!start) {
            this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
            return false;
        }
        return true;
    }

    public boolean startSSLEndpoint(int port, String name, InboundProcessorParams inboundParameters) {
        if (this.handleExistingEndpointOnSamePort(port, name)) {
            return true;
        }
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        this.dataStore.registerListeningEndpoint(port, tenantDomain, InboundRequestProcessorFactoryImpl.Protocols.httpswss.toString(), name, inboundParameters);
        boolean start = this.startSSLListener(port, name, inboundParameters);
        if (!start) {
            this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
            return false;
        }
        return true;
    }

    @Override
    public boolean startListener(int port, String name, InboundProcessorParams inboundParameters) {
        if (HttpWebsocketEndpointManager.isPortOccupied(port)) {
            LOGGER.error((Object)("A service is already listening on port " + port + ". Please select a different port for this endpoint."));
            return false;
        }
        ConfigurationContext configurationContext = ServiceReferenceHolder.getInstance().getConfigurationContextService().getServerConfigContext();
        HttpWebSocketInboundEndpointConfiguration configuration = HttpWebsocketEndpointManager.getHttpWebSocketInboundEndpointConfiguration(port, name, inboundParameters, false);
        return HttpWebSocketInboundEndpointHandler.startListener((ConfigurationContext)configurationContext, (HttpWebSocketInboundEndpointConfiguration)configuration);
    }

    public boolean startSSLListener(int port, String name, InboundProcessorParams inboundParameters) {
        if (HttpWebsocketEndpointManager.isPortOccupied(port)) {
            LOGGER.error((Object)("A service is already listening on port " + port + ". Please select a different port for this endpoint."));
            return false;
        }
        ConfigurationContext configurationContext = ServiceReferenceHolder.getInstance().getConfigurationContextService().getServerConfigContext();
        HttpWebSocketInboundEndpointConfiguration configuration = HttpWebsocketEndpointManager.getHttpWebSocketInboundEndpointConfiguration(port, name, inboundParameters, true);
        return HttpWebSocketInboundEndpointHandler.startSSLListener((ConfigurationContext)configurationContext, (HttpWebSocketInboundEndpointConfiguration)configuration);
    }

    @Override
    public void closeEndpoint(int port) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
        HttpWebSocketInboundEndpointHandler.closeEndpoint((int)port);
    }

    private boolean handleExistingEndpointOnSamePort(int port, String name) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        String epName = this.dataStore.getListeningEndpointName(port, tenantDomain);
        if (epName == null) {
            return false;
        }
        if (epName.equalsIgnoreCase(name)) {
            LOGGER.info((Object)(epName + " Endpoint is already started in port : " + port));
            return true;
        }
        String msg = "Another endpoint named: " + epName + " is currently using this port: " + port;
        LOGGER.warn((Object)msg);
        throw new SynapseException(msg);
    }

    public static boolean isPortOccupied(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
            return false;
        }
        catch (IOException var2) {
            return true;
        }
    }

    public static HttpWebSocketInboundEndpointConfiguration getHttpWebSocketInboundEndpointConfiguration(int port, String name, InboundProcessorParams params, boolean isSSL) {
        String hostname = params.getProperties().getProperty("hostname");
        String protocolVersion = params.getProperties().getProperty("protocolVersion");
        HttpWebSocketInboundEndpointConfiguration configuration = new HttpWebSocketInboundEndpointConfiguration(port, hostname, name, protocolVersion, params.getHandlers());
        if (isSSL) {
            configuration.setSslConfiguration(HttpWebsocketEndpointManager.buildSSLConfiguration(params));
        }
        return configuration;
    }

    public static SSLConfiguration buildSSLConfiguration(InboundProcessorParams params) {
        String keyStoreParam = params.getProperties().getProperty("keystore");
        String trustStoreParam = params.getProperties().getProperty("truststore");
        String clientAuthParam = params.getProperties().getProperty("SSLVerifyClient");
        String sslProtocol = params.getProperties().getProperty("SSLProtocol");
        String httpsProtocols = params.getProperties().getProperty("HttpsProtocols");
        String certificateRevocation = params.getProperties().getProperty("CertificateRevocationVerifier");
        String preferredCiphers = params.getProperties().getProperty("PreferredCiphers");
        String sessionTimeout = params.getProperties().getProperty("SessionTimeout");
        String handshakeTimeout = params.getProperties().getProperty("HandshakeTimeout");
        return new SSLConfiguration.SSLConfigurationBuilder().keyStore(keyStoreParam).trustStore(trustStoreParam).clientAuthEl(clientAuthParam).httpsProtocolsEl(httpsProtocols).revocationVerifier(certificateRevocation).sslProtocol(sslProtocol).preferredCiphersEl(preferredCiphers).sessionTimeout(sessionTimeout).handshakeTimeout(handshakeTimeout).build();
    }
}

