/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.jms;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.wso2.carbon.inbound.endpoint.common.InboundTask;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSPollingConsumer;
import org.wso2.carbon.ntask.core.impl.LocalTaskActionListener;

public class JMSTask
extends InboundTask
implements LocalTaskActionListener {
    private static final Log logger = LogFactory.getLog((String)JMSTask.class.getName());
    private JMSPollingConsumer jmsPollingConsumer;

    public JMSTask(JMSPollingConsumer jmsPollingConsumer, long interval) {
        logger.debug((Object)"Initializing JMS Task.");
        this.jmsPollingConsumer = jmsPollingConsumer;
        this.interval = interval;
    }

    @Override
    protected void taskExecute() {
        logger.debug((Object)"Executing JMS Task Execution.");
        this.jmsPollingConsumer.execute();
    }

    @Override
    public Properties getInboundProperties() {
        return this.jmsPollingConsumer.getInboundProperites();
    }

    public void init(SynapseEnvironment synapseEnvironment) {
        logger.debug((Object)"Initializing.");
    }

    public void destroy() {
        logger.debug((Object)"Destroying JMS Task.");
        this.jmsPollingConsumer.destroy();
    }

    public void notifyLocalTaskDeletion(String taskName) {
        this.destroy();
        logger.debug((Object)("Destroyed JMS task due to deletion of task: " + taskName));
    }
}

