/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import com.rabbitmq.client.AMQP;
import java.util.UUID;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.AcknowledgementMode;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQUtils;

public class RabbitMQInjectHandler {
    private static final Log log = LogFactory.getLog(RabbitMQInjectHandler.class);
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;
    private SynapseEnvironment synapseEnvironment;
    private SequenceMediator seq;

    public RabbitMQInjectHandler(String injectingSeq, String onErrorSeq, boolean sequential, SynapseEnvironment synapseEnvironment) {
        this.injectingSeq = injectingSeq;
        if (injectingSeq == null || injectingSeq.equals("")) {
            String msg = "Injecting Sequence name is not specified.";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.seq = (SequenceMediator)synapseEnvironment.getSynapseConfiguration().getSequence(injectingSeq);
        if (this.seq == null) {
            throw new SynapseException("Specified injecting sequence: " + injectingSeq + "is invalid.");
        }
        if (!this.seq.isInitialized()) {
            this.seq.init(synapseEnvironment);
        }
        this.onErrorSeq = onErrorSeq;
        this.sequential = sequential;
        this.synapseEnvironment = synapseEnvironment;
    }

    public AcknowledgementMode onMessage(AMQP.BasicProperties properties, byte[] body, String inboundName) {
        org.apache.synapse.MessageContext msgCtx = this.createMessageContext();
        try {
            MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
            RabbitMQUtils.buildMessage(properties, body, axis2MsgCtx);
            axis2MsgCtx.setProperty("TRANSPORT_HEADERS", RabbitMQUtils.getTransportHeaders(properties));
            if (this.seq != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("injecting message to sequence : " + this.injectingSeq));
                }
                this.seq.setErrorHandler(this.onErrorSeq);
                msgCtx.setProperty("isInbound", (Object)true);
                msgCtx.setProperty("inbound.endpoint.name", (Object)inboundName);
                msgCtx.setProperty("ARTIFACT_NAME", (Object)("inboundendpoint" + inboundName));
                this.synapseEnvironment.injectInbound(msgCtx, this.seq, this.sequential);
            } else {
                log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
            }
            Object rollbackProperty = msgCtx.getProperty("SET_ROLLBACK_ONLY");
            if (rollbackProperty instanceof Boolean && ((Boolean)rollbackProperty).booleanValue() || rollbackProperty instanceof String && Boolean.parseBoolean((String)rollbackProperty)) {
                return AcknowledgementMode.REQUEUE_FALSE;
            }
            Object requeueOnRollbackProperty = msgCtx.getProperty("SET_REQUEUE_ON_ROLLBACK");
            if (requeueOnRollbackProperty instanceof Boolean && ((Boolean)requeueOnRollbackProperty).booleanValue() || requeueOnRollbackProperty instanceof String && Boolean.parseBoolean((String)requeueOnRollbackProperty)) {
                return AcknowledgementMode.REQUEUE_TRUE;
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error when trying to read incoming message ...", (Throwable)axisFault);
            return AcknowledgementMode.REQUEUE_FALSE;
        }
        return AcknowledgementMode.ACKNOWLEDGE;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UUID.randomUUID().toString());
        msgCtx.setProperty("ClientApiNonBlocking", (Object)true);
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        axis2MsgCtx.setProperty("tenantDomain", (Object)carbonContext.getTenantDomain());
        return msgCtx;
    }
}

