/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket.configuration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NettyThreadPoolConfiguration {
    private static final Log log = LogFactory.getLog(NettyThreadPoolConfiguration.class);
    private int bossThreadPoolSize;
    private int workerThreadPoolSize;

    public NettyThreadPoolConfiguration(String bossThreadPoolSize, String workerThreadPoolSize) {
        try {
            this.bossThreadPoolSize = bossThreadPoolSize != null && !"".equals(bossThreadPoolSize.trim()) ? Integer.parseInt(bossThreadPoolSize) : Runtime.getRuntime().availableProcessors();
            this.workerThreadPoolSize = workerThreadPoolSize != null && !"".equals(workerThreadPoolSize.trim()) ? Integer.parseInt(workerThreadPoolSize) : Runtime.getRuntime().availableProcessors() * 2;
        }
        catch (Exception e) {
            log.error((Object)"failed to validate the Netty thread pool configuration", (Throwable)e);
        }
    }

    public int getBossThreadPoolSize() {
        return this.bossThreadPoolSize;
    }

    public int getWorkerThreadPoolSize() {
        return this.workerThreadPoolSize;
    }
}

