/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket.management;

import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketChannelContext;

public class WebsocketSubscriberPathManager {
    private static WebsocketSubscriberPathManager instance = null;
    private static final Log log = LogFactory.getLog(WebsocketSubscriberPathManager.class);
    private ConcurrentHashMap<String, ConcurrentHashMap<String, List<InboundWebsocketChannelContext>>> inboundSubscriberPathMap = new ConcurrentHashMap();

    public static WebsocketSubscriberPathManager getInstance() {
        if (instance == null) {
            instance = new WebsocketSubscriberPathManager();
        }
        return instance;
    }

    public void addChannelContext(String inboundName, String subscriberPath, InboundWebsocketChannelContext ctx) {
        ConcurrentHashMap<String, List<InboundWebsocketChannelContext>> subscriberPathMap;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Channel Context with channelID: " + ctx.getChannelIdentifier() + ", in the Thread,ID: " + Thread.currentThread().getName() + "," + Thread.currentThread().getId()));
        }
        if ((subscriberPathMap = this.inboundSubscriberPathMap.get(inboundName)) == null) {
            subscriberPathMap = new ConcurrentHashMap();
            ArrayList<InboundWebsocketChannelContext> listContext = new ArrayList<InboundWebsocketChannelContext>();
            listContext.add(ctx);
            subscriberPathMap.put(subscriberPath, listContext);
            this.inboundSubscriberPathMap.put(inboundName, subscriberPathMap);
        } else {
            List<InboundWebsocketChannelContext> listContext = subscriberPathMap.get(subscriberPath);
            if (listContext == null) {
                listContext = new ArrayList<InboundWebsocketChannelContext>();
                listContext.add(ctx);
                subscriberPathMap.put(subscriberPath, listContext);
            } else {
                listContext.add(ctx);
            }
        }
    }

    public void removeChannelContext(String inboundName, String subscriberPath, InboundWebsocketChannelContext ctx) {
        ConcurrentHashMap<String, List<InboundWebsocketChannelContext>> subscriberPathMap = this.inboundSubscriberPathMap.get(inboundName);
        List<InboundWebsocketChannelContext> listContext = subscriberPathMap.get(subscriberPath);
        for (Object context : listContext.toArray()) {
            if (!((InboundWebsocketChannelContext)context).getChannelIdentifier().equals(ctx.getChannelIdentifier())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing Channel Context with channelID: " + ctx.getChannelIdentifier() + ", in the Thread,ID: " + Thread.currentThread().getName() + "," + Thread.currentThread().getId()));
            }
            listContext.remove(context);
            break;
        }
        if (listContext.isEmpty()) {
            listContext.clear();
            subscriberPathMap.remove(subscriberPath);
        }
        if (subscriberPathMap.isEmpty()) {
            subscriberPathMap.clear();
            this.inboundSubscriberPathMap.remove(inboundName);
        }
    }

    public List<InboundWebsocketChannelContext> getSubscriberPathChannelContextList(String inboundName, String subscriberPath) {
        if (this.inboundSubscriberPathMap.get(inboundName) != null) {
            return this.inboundSubscriberPathMap.get(inboundName).get(subscriberPath);
        }
        return Collections.emptyList();
    }

    public void broadcastOnSubscriberPath(WebSocketFrame frame, String inboundName, String subscriberPath) {
        List<InboundWebsocketChannelContext> contextList = this.getSubscriberPathChannelContextList(inboundName, subscriberPath);
        if (contextList != null) {
            for (InboundWebsocketChannelContext context : contextList) {
                WebSocketFrame duplicatedFrame = frame.duplicate();
                context.writeToChannel(duplicatedFrame.retain());
            }
        }
    }

    public void exclusiveBroadcastOnSubscriberPath(WebSocketFrame frame, String inboundName, String subscriberPath, InboundWebsocketChannelContext ctx) {
        List<InboundWebsocketChannelContext> contextList = this.getSubscriberPathChannelContextList(inboundName, subscriberPath);
        for (InboundWebsocketChannelContext context : contextList) {
            if (context.getChannelIdentifier().equals(ctx.getChannelIdentifier())) continue;
            WebSocketFrame duplicatedFrame = frame.duplicate();
            context.writeToChannel(duplicatedFrame.retain());
        }
    }
}

