/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt.resolvers;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.Mediator;
import org.apache.synapse.mediators.throttle.ThrottleMediator;
import org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject;
import org.wso2.carbon.mediation.dependency.mgt.DependencyResolver;
import org.wso2.carbon.mediation.dependency.mgt.DependencyResolverFactory;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.AbstractDependencyResolver;

public class ThrottleMediatorResolver
extends AbstractDependencyResolver {
    @Override
    public List<ConfigurationObject> resolve(Mediator m) {
        List<ConfigurationObject> sequenceProviders;
        DependencyResolver resolver;
        if (!(m instanceof ThrottleMediator)) {
            return null;
        }
        ArrayList<ConfigurationObject> providers = new ArrayList<ConfigurationObject>();
        ThrottleMediator throttleMediator = (ThrottleMediator)m;
        if (throttleMediator.getOnAcceptMediator() != null) {
            resolver = DependencyResolverFactory.getInstance().getResolver(throttleMediator.getOnAcceptMediator());
            sequenceProviders = resolver.resolve(throttleMediator.getOnAcceptMediator());
            for (ConfigurationObject o : sequenceProviders) {
                this.addProvider(o, providers);
            }
        } else if (throttleMediator.getOnAcceptSeqKey() != null) {
            this.addProvider(new ConfigurationObject(1, throttleMediator.getOnAcceptSeqKey()), providers);
        }
        if (throttleMediator.getOnRejectMediator() != null) {
            resolver = DependencyResolverFactory.getInstance().getResolver(throttleMediator.getOnRejectMediator());
            sequenceProviders = resolver.resolve(throttleMediator.getOnRejectMediator());
            for (ConfigurationObject o : sequenceProviders) {
                this.addProvider(o, providers);
            }
        } else if (throttleMediator.getOnRejectSeqKey() != null) {
            this.addProvider(new ConfigurationObject(1, throttleMediator.getOnRejectSeqKey()), providers);
        }
        return providers;
    }
}

