/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MultiXMLConfigurationSerializer;
import org.wso2.carbon.mediation.initializer.persistence.ServiceBusPersistenceException;
import org.wso2.carbon.mediation.initializer.persistence.registry.AbstractRegistryStore;

public abstract class AbstractStore<T> {
    protected Log log = LogFactory.getLog(this.getClass());
    protected String configPath;
    protected AbstractRegistryStore registryStore;
    protected MultiXMLConfigurationSerializer serializer;

    public AbstractStore(String configPath) {
        this.configPath = configPath;
        this.serializer = new MultiXMLConfigurationSerializer(configPath);
    }

    public void save(String name, SynapseConfiguration config) {
        if (name == null) {
            this.log.warn((Object)"Name of the configuration item to be saved is not given");
            return;
        }
        T obj = this.getObjectToPersist(name, config);
        if (obj == null) {
            this.log.warn((Object)("Unable to find the item: " + name + " for persistence"));
            return;
        }
        OMElement element = null;
        String fileName = this.getFileName(obj);
        if (fileName == null) {
            try {
                this.serializer.serializeSynapseXML(config);
            }
            catch (Exception e) {
                this.handleException("Error while saving the mediation configuration to the file system", e);
            }
        } else {
            element = this.saveToFile(obj, config);
        }
        if (this.registryStore != null) {
            if (element == null) {
                element = this.serialize(obj);
            }
            this.saveToRegistry(name, element, fileName);
        }
    }

    public void delete(String name, String fileName, SynapseConfiguration config) {
        if (fileName == null) {
            try {
                this.serializer.serializeSynapseXML(config);
            }
            catch (Exception e) {
                this.handleException("Error while saving the mediation configuration to the file system", e);
            }
        } else {
            this.deleteFile(fileName, config);
        }
        if (this.registryStore != null) {
            this.deleteFromRegistry(name);
        }
    }

    protected abstract OMElement saveToFile(T var1, SynapseConfiguration var2);

    protected abstract void deleteFile(String var1, SynapseConfiguration var2);

    protected abstract T getObjectToPersist(String var1, SynapseConfiguration var2);

    protected abstract String getFileName(T var1);

    protected abstract OMElement serialize(T var1);

    public void saveItemToRegistry(String name, SynapseConfiguration config) {
        if (this.registryStore == null) {
            return;
        }
        if (name == null) {
            this.log.warn((Object)"Name of the configuration item is not given");
            return;
        }
        T obj = this.getObjectToPersist(name, config);
        if (obj == null) {
            this.log.warn((Object)("Unable to find the item: " + name + " for persistence"));
            return;
        }
        OMElement element = this.serialize(obj);
        this.saveToRegistry(name, element, this.getFileName(obj));
    }

    public void deleteItemFromRegistry(String name) {
        if (this.registryStore != null) {
            this.deleteFromRegistry(name);
        }
    }

    protected void saveToRegistry(String name, OMElement element, String fileName) {
        if (element != null && this.registryStore != null) {
            if (name == null) {
                this.log.warn((Object)"Name of the configuration item to be saved is not given");
                return;
            }
            this.registryStore.persistElement(name, element, fileName);
        }
    }

    protected void deleteFromRegistry(String name) {
        if (this.registryStore != null) {
            if (name == null) {
                this.log.warn((Object)"Name of the configuration item to be deleted is not given");
                return;
            }
            this.registryStore.deleteElement(name);
        }
    }

    protected void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new ServiceBusPersistenceException(msg, e);
    }
}

