/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MessageStoreSerializer;
import org.apache.synapse.message.store.MessageStore;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.MessageStoreRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class MessageStoreStore
extends AbstractStore<MessageStore> {
    public MessageStoreStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new MessageStoreRegistryStore(registry, configName);
        }
    }

    @Override
    protected OMElement saveToFile(MessageStore store, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeMessageStore(store, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the Message Store: " + store.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration config) {
        File msDir = new File(this.configPath, "message-stores");
        if (!msDir.exists()) {
            return;
        }
        File msFile = new File(msDir, fileName);
        config.getArtifactDeploymentStore().addBackedUpArtifact(msFile.getAbsolutePath());
        msFile.delete();
    }

    @Override
    protected MessageStore getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getMessageStore(name);
    }

    @Override
    protected String getFileName(MessageStore messageStore) {
        return messageStore.getFileName();
    }

    @Override
    protected OMElement serialize(MessageStore obj) {
        return MessageStoreSerializer.serializeMessageStore(null, (MessageStore)obj);
    }
}

