/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.ntask.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.TaskStartupObserver;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.mediation.ntask.TaskServiceObserver;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="esbntask.taskservice", immediate=true)
public class NtaskService {
    private static final Log logger = LogFactory.getLog(NtaskService.class);
    private static final List<TaskServiceObserver> observers = new ArrayList<TaskServiceObserver>();
    private static TaskService taskService;
    private static final List<TaskStartupObserver> startupObservers;
    private static ConfigurationContextService ccServiceInstance;
    private static final Object lock;
    private static RealmService realmService;
    private static ConfigurationContextService configContextService;

    @Activate
    protected void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            logger.debug((Object)"ntask-integration bundle is activated.");
        }
        catch (Throwable e) {
            logger.error((Object)("Could not activate NTaskService. Error: " + e.getMessage()), e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        logger.debug((Object)"ntask-integration bundle is deactivated.");
    }

    @Reference(name="tasks.component", service=TaskService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTaskService")
    protected void setTaskService(TaskService taskService) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting the Task Service [" + taskService + "]."));
        }
        NtaskService.taskService = taskService;
        this.updateAndCleanupObservers();
    }

    protected void unsetTaskService(TaskService taskService) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unsetting the Task Service [" + taskService + "]"));
        }
        NtaskService.taskService = null;
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        configContextService = contextService;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting Configuration Context Service [" + contextService + "]"));
        }
        ccServiceInstance = contextService;
        this.updateAndCleanupObservers();
    }

    private void updateAndCleanupObservers() {
        Iterator<TaskServiceObserver> i = observers.iterator();
        while (i.hasNext()) {
            TaskServiceObserver observer = i.next();
            if (!observer.update(null)) continue;
            i.remove();
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unsetting Configuration Context Service [" + contextService + "]"));
        }
        ccServiceInstance = null;
    }

    public static ConfigurationContextService getCcServiceInstance() {
        return ccServiceInstance;
    }

    public static void addObserver(TaskServiceObserver o) {
        if (observers.contains(o)) {
            return;
        }
        observers.add(o);
    }

    public static TaskService getTaskService() {
        return taskService;
    }

    @Reference(name="org.wso2.carbon.tenantPreLoadComponent.user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmSrv) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting the Realm Service.");
        }
        realmService = realmSrv;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Un-setting the Realm Service.");
        }
        realmService = null;
    }

    public static void loadTenant(int tenantId) {
        if (realmService == null || configContextService == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to load tenants with scheduled tasks. Required services are not loaded.");
            }
            return;
        }
        try {
            ConfigurationContext mainConfigCtx = configContextService.getServerConfigContext();
            String tenantDomain = realmService.getTenantManager().getDomain(tenantId);
            TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)mainConfigCtx);
            if (logger.isDebugEnabled()) {
                logger.info((Object)("Load the tenant. Id : " + tenantId + " Domain : " + tenantDomain));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when loading tenant before executing the task.", (Throwable)e);
        }
    }

    static {
        startupObservers = new ArrayList<TaskStartupObserver>();
        lock = new Object();
        realmService = null;
        configContextService = null;
    }
}

