/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.internal.ConfigHolder;

public class SequenceAdminUtil {
    private static final Log log = LogFactory.getLog(SequenceAdminUtil.class);

    public static SynapseConfiguration getSynapseConfiguration() throws SequenceEditorException {
        return (SynapseConfiguration)ConfigHolder.getInstance().getAxisConfiguration().getParameter("synapse.config").getValue();
    }

    public static SynapseConfiguration getSynapseConfigFromConfigCtx() throws SequenceEditorException {
        return (SynapseConfiguration)ConfigHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getParameter("synapse.config").getValue();
    }

    public static SynapseEnvironment getSynapseEnvironment() throws SequenceEditorException {
        return SequenceAdminUtil.getSynapseEnvironment(ConfigHolder.getInstance().getAxisConfiguration());
    }

    public static SynapseEnvironment getSynapseEnvironmentFromConfigCtx() throws SequenceEditorException {
        return SequenceAdminUtil.getSynapseEnvironment(ConfigHolder.getInstance().getConfigurationContextService().getServerConfigContext().getAxisConfiguration());
    }

    public static SynapseEnvironment getSynapseEnvironment(AxisConfiguration axisCfg) {
        return (SynapseEnvironment)axisCfg.getParameter("synapse.env").getValue();
    }

    public static MediationPersistenceManager getMediationPersistenceManager() throws SequenceEditorException {
        return ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)ConfigHolder.getInstance().getAxisConfiguration());
    }

    public static ServerConfigurationInformation getServerConfigurationInformation() throws SequenceEditorException {
        Parameter p = ConfigHolder.getInstance().getAxisConfiguration().getParameter("synapse.server.config.info");
        if (p != null) {
            return (ServerConfigurationInformation)p.getValue();
        }
        return null;
    }

    public static ServerContextInformation getServerContextInformation() throws SequenceEditorException {
        Parameter p = ConfigHolder.getInstance().getAxisConfiguration().getParameter("synapse.server.context.info");
        if (p != null) {
            return (ServerContextInformation)p.getValue();
        }
        return null;
    }

    public static Lock getLock() throws SequenceEditorException {
        Parameter p = ConfigHolder.getInstance().getAxisConfiguration().getParameter("synapse.config.lock");
        if (p != null) {
            return (Lock)p.getValue();
        }
        log.warn((Object)"synapse.config.lock is null, Recreating a new lock");
        ReentrantLock lock = new ReentrantLock();
        try {
            ConfigHolder.getInstance().getAxisConfiguration().addParameter("synapse.config.lock", (Object)lock);
            return lock;
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while setting synapse.config.lock");
            return null;
        }
    }
}

