/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.Utils;

public class DefaultBundleCreator
implements CarbonLaunchExtension {
    private static final String JARS_DIR;

    @Override
    public void perform() {
        String dropinsPath = System.getProperty("carbon.dropins.dir.path");
        File dropinsFolder = dropinsPath == null ? new File(Utils.getCarbonComponentRepo(), "dropins") : new File(dropinsPath);
        File dir = Utils.getBundleDirectory(JARS_DIR);
        File[] files = dir.listFiles(new Utils.JarFileFilter());
        if (files != null) {
            for (File file : files) {
                try {
                    Manifest mf = new Manifest();
                    Attributes attribs = mf.getMainAttributes();
                    attribs.putValue("DynamicImport-Package", "*");
                    Utils.createBundle(file, dropinsFolder, mf, "");
                }
                catch (Throwable e) {
                    System.err.println("Cannot create bundle from jar file " + file.getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        String externalLibPath = System.getProperty("carbon.external.lib.dir.path");
        if (externalLibPath != null) {
            JARS_DIR = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(externalLibPath, new String[0])).toString();
        } else {
            String componentPath = System.getProperty("carbon.components.dir.path");
            if (componentPath == null) {
                JARS_DIR = Paths.get("repository", "components", "lib").toString();
            } else {
                Path path = Paths.get(componentPath, "lib");
                JARS_DIR = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(path).toString();
            }
        }
    }
}

