/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.BundleInfoLine;
import org.wso2.carbon.server.util.FileUtils;
import org.wso2.carbon.server.util.Utils;

public class DropinsBundleDeployer
implements CarbonLaunchExtension {
    private static final Logger logger = Logger.getLogger(DropinsBundleDeployer.class.getName());
    private static String dropinsDirPath = System.getProperty("carbon.dropins.dir.path");
    private static String bundlesInfoDirPath;
    private static final String DEFAULT_BUNDLE_VERSION = "0.0.0";

    @Override
    public void perform() {
        try {
            File dropinsDir = Utils.getBundleDirectory(dropinsDirPath);
            File[] files = dropinsDir.listFiles(new Utils.JarFileFilter());
            if (files == null) {
                return;
            }
            BundleInfoLine[] newBundleInfoLines = this.getNewBundleInfoLines(files);
            File bundlesInfoDir = Utils.getBundleDirectory(bundlesInfoDirPath);
            File bundlesInfoFile = new File(bundlesInfoDir, "bundles.info");
            if (!bundlesInfoFile.exists()) {
                return;
            }
            Map<String, List<BundleInfoLine>> bundleInfoLineMap = this.processBundlesInfoFile(bundlesInfoFile, newBundleInfoLines);
            this.addNewBundleInfoLines(newBundleInfoLines, bundleInfoLineMap);
            this.updateBundlesInfoFile(bundlesInfoFile, bundleInfoLineMap);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error occured while deploying bundles in the dropins directory", e);
        }
    }

    private BundleInfoLine[] getNewBundleInfoLines(File[] bundleFileList) throws Exception {
        ArrayList<BundleInfoLine> bundleInfoArray = new ArrayList<BundleInfoLine>();
        for (File file : bundleFileList) {
            try (JarFile jarFile = new JarFile(file.getAbsoluteFile());){
                if (jarFile.getManifest() == null || jarFile.getManifest().getMainAttributes() == null) {
                    logger.log(Level.SEVERE, "Invalid Bundle found in the dropins directory: " + file.getName());
                    continue;
                }
                String bundleSymbolicName = jarFile.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
                String bundleVersion = jarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
                if (bundleSymbolicName == null || bundleVersion == null) {
                    logger.log(Level.SEVERE, "Required Bundle manifest headers do not exists: " + file.getAbsoluteFile());
                    continue;
                }
                if (bundleSymbolicName.contains(";")) {
                    bundleSymbolicName = bundleSymbolicName.split(";")[0];
                }
                if (bundleVersion == null) {
                    bundleVersion = DEFAULT_BUNDLE_VERSION;
                }
                boolean isFragment = jarFile.getManifest().getMainAttributes().getValue("Fragment-Host") != null;
                String dropinsAbsolutePath = System.getProperty("carbon.dropins.dir.path");
                if (dropinsAbsolutePath != null) {
                    String compoenentProfilePath = Paths.get(Utils.getCarbonComponentRepo().getPath(), System.getProperty("profile")).toString();
                    String relativePathToDropinsFolder = Paths.get(compoenentProfilePath, new String[0]).relativize(Paths.get(dropinsAbsolutePath, new String[0])).toString();
                    bundleInfoArray.add(new BundleInfoLine(bundleSymbolicName, bundleVersion, Paths.get(relativePathToDropinsFolder, file.getName()).toString(), 4, isFragment));
                    continue;
                }
                bundleInfoArray.add(new BundleInfoLine(bundleSymbolicName, bundleVersion, Paths.get("..", "dropins", file.getName()).toString(), 4, isFragment));
            }
        }
        return bundleInfoArray.toArray(new BundleInfoLine[bundleInfoArray.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<BundleInfoLine>> processBundlesInfoFile(File bundlesInfoFile, BundleInfoLine[] newBundleInfoLines) throws Exception {
        HashMap<String, List<BundleInfoLine>> bundleInfoLineMap = new HashMap<String, List<BundleInfoLine>>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(bundlesInfoFile.getAbsoluteFile()));
            while ((line = reader.readLine()) != null) {
                ArrayList<BundleInfoLine> bundleInfoLineList;
                if (line.startsWith("#")) continue;
                BundleInfoLine bundleInfoLine = BundleInfoLine.getInstance(line);
                if (bundleInfoLine.isFromDropins()) {
                    boolean found = false;
                    for (BundleInfoLine newBundleInfoLine : newBundleInfoLines) {
                        if (!newBundleInfoLine.getBundleSymbolicName().equals(bundleInfoLine.getBundleSymbolicName()) || !newBundleInfoLine.getBundleVersion().equals(bundleInfoLine.getBundleVersion()) || newBundleInfoLine.isFragment() ^ bundleInfoLine.isFragment()) continue;
                        found = true;
                    }
                    if (!found) continue;
                }
                if ((bundleInfoLineList = (ArrayList<BundleInfoLine>)bundleInfoLineMap.get(bundleInfoLine.getBundleSymbolicName())) == null) {
                    bundleInfoLineList = new ArrayList<BundleInfoLine>();
                    bundleInfoLineList.add(bundleInfoLine);
                    bundleInfoLineMap.put(bundleInfoLine.getBundleSymbolicName(), bundleInfoLineList);
                    continue;
                }
                bundleInfoLineList.add(bundleInfoLine);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Unable to close the InputStream " + e.getMessage(), e);
                }
            }
        }
        return bundleInfoLineMap;
    }

    private void addNewBundleInfoLines(BundleInfoLine[] newBundleInfoLines, Map<String, List<BundleInfoLine>> existingBundleInfoLineMap) {
        for (BundleInfoLine newBundleInfoLine : newBundleInfoLines) {
            String symbolicName = newBundleInfoLine.getBundleSymbolicName();
            String version = newBundleInfoLine.getBundleVersion();
            boolean isFragment = newBundleInfoLine.isFragment();
            List<BundleInfoLine> bundleInfoLineList = existingBundleInfoLineMap.get(symbolicName);
            if (bundleInfoLineList == null) {
                bundleInfoLineList = new ArrayList<BundleInfoLine>();
                bundleInfoLineList.add(newBundleInfoLine);
                existingBundleInfoLineMap.put(symbolicName, bundleInfoLineList);
                logger.log(Level.FINE, "Deploying bundle: " + newBundleInfoLine.getBundlePath());
                continue;
            }
            boolean found = false;
            for (BundleInfoLine existingBundleInfoLIne : bundleInfoLineList) {
                if (!existingBundleInfoLIne.getBundleVersion().equals(version)) continue;
                if (existingBundleInfoLIne.isFragment() ^ isFragment) {
                    if (existingBundleInfoLIne.getBundlePath().equals(newBundleInfoLine.getBundlePath())) continue;
                    logger.log(Level.WARNING, "Ignoring the deployment of bundle: " + newBundleInfoLine.getBundlePath() + ", because it is already available in the system: " + existingBundleInfoLIne.getBundlePath() + ". Bundle-SymbolicName and Bundle-Version headers are identical ");
                    found = true;
                    break;
                }
                if (existingBundleInfoLIne.getBundlePath().equals(newBundleInfoLine.getBundlePath())) {
                    logger.log(Level.FINE, "Deploying bundle: " + newBundleInfoLine.getBundlePath());
                    found = true;
                    break;
                }
                logger.log(Level.WARNING, "Ignoring the deployment of bundle: " + newBundleInfoLine.getBundlePath() + ", because it is already available in the system: " + existingBundleInfoLIne.getBundlePath() + ". Bundle-SymbolicName and Bundle-Version headers are identical ");
                found = true;
                break;
            }
            if (found) continue;
            bundleInfoLineList.add(newBundleInfoLine);
            logger.log(Level.FINE, "Deploying bundle: " + newBundleInfoLine.getBundlePath());
        }
    }

    private void updateBundlesInfoFile(File bundlesInfoFile, Map<String, List<BundleInfoLine>> bundleInfoLineMap) throws Exception {
        BufferedWriter writer = null;
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            if (tempDir == null || tempDir.length() == 0) {
                throw new Exception("java.io.tmpdir property is null. Cannot proceed.");
            }
            String tempBundlesInfoDirPath = tempDir + File.separator + "bundles_info_" + UUID.randomUUID().toString();
            String tempBundlesInfoFilePath = tempBundlesInfoDirPath + File.separator + "bundles.info";
            File tempBundlesInfoDir = new File(tempBundlesInfoDirPath);
            boolean created = tempBundlesInfoDir.mkdir();
            if (!created) {
                throw new IOException("Failed to create the directory: " + tempBundlesInfoFilePath);
            }
            writer = new BufferedWriter(new FileWriter(tempBundlesInfoFilePath, true));
            Object[] keyArray = bundleInfoLineMap.keySet().toArray(new String[bundleInfoLineMap.keySet().size()]);
            Arrays.sort(keyArray);
            for (Object key : keyArray) {
                List<BundleInfoLine> bundleInfoLineList = bundleInfoLineMap.get(key);
                for (BundleInfoLine bundleInfoLine : bundleInfoLineList) {
                    writer.write(bundleInfoLine.toString());
                    writer.newLine();
                }
            }
            writer.flush();
            FileUtils.copyFile(new File(tempBundlesInfoFilePath), bundlesInfoFile, false);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception("Error occurred while updating the bundles.info file.", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to close the OutputStream " + e.getMessage(), e);
            }
        }
    }

    static {
        String componentPath = System.getProperty("carbon.components.dir.path");
        String profileName = System.getProperty("profile", "default");
        if (componentPath == null) {
            bundlesInfoDirPath = Paths.get("repository", "components", profileName, "configuration", "org.eclipse.equinox.simpleconfigurator").toString();
        } else {
            componentPath = Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(componentPath, new String[0])).toString();
            bundlesInfoDirPath = Paths.get(componentPath, profileName, "configuration", "org.eclipse.equinox.simpleconfigurator").toString();
        }
        dropinsDirPath = dropinsDirPath == null ? (componentPath == null ? Paths.get("repository", "components", "dropins").toString() : Paths.get(componentPath, "dropins").toString()) : Paths.get(System.getProperty("carbon.home"), new String[0]).relativize(Paths.get(dropinsDirPath, new String[0])).toString();
    }
}

