/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.server.CarbonLaunchExtension;

public class EclipseIniRewriter
implements CarbonLaunchExtension {
    private static final Logger logger = Logger.getLogger(EclipseIniRewriter.class.getName());
    private static final String CARBON_OSGI_DIR_LOCATION;

    @Override
    public void perform() {
        File eclipseIni = null;
        String profileName = System.getProperty("profile", "default");
        String profileLocation = CARBON_OSGI_DIR_LOCATION + File.separator + profileName;
        try {
            profileLocation = new File(profileLocation).getCanonicalPath();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "The directory : " + profileName + "does not exist..", e);
        }
        eclipseIni = new File(profileLocation + File.separator + "null.ini");
        if (eclipseIni.exists()) {
            logger.log(Level.FINE, "processing the null.ini file found in " + profileLocation);
            this.rewriteFile(eclipseIni, profileLocation);
            return;
        }
        eclipseIni = new File(profileLocation + File.separator + "eclipse.ini");
        if (eclipseIni.exists()) {
            logger.log(Level.FINE, "processing the eclispe.ini file found in " + profileLocation);
            this.rewriteFile(eclipseIni, profileLocation);
            return;
        }
    }

    private void rewriteFile(File file, String profileLocation) {
        file.delete();
        try (PrintWriter pw = new PrintWriter(new FileWriter(file));){
            pw.write("-install\n");
            pw.write(profileLocation);
            pw.flush();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while writing to file " + file.getName(), e);
        }
    }

    static {
        String componentsPath = System.getProperty("carbon.components.dir.path");
        CARBON_OSGI_DIR_LOCATION = componentsPath == null ? Paths.get(System.getProperty("carbon.home"), "repository", "components").toString() : componentsPath;
    }
}

