/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.dashboard;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.micro.integrator.initializer.dashboard.HeartBeatComponent;

public class ArtifactDeploymentListener {
    private static final Log log = LogFactory.getLog(ArtifactDeploymentListener.class);
    private static JsonArray deployedArtifacts = new JsonArray();
    private static JsonArray undeployedArtifacts = new JsonArray();

    private ArtifactDeploymentListener() {
    }

    public static void addToDeployedArtifactsQueue(JsonObject deployedArtifact) {
        if (HeartBeatComponent.isDashboardConfigured()) {
            log.debug((Object)("Adding " + deployedArtifact.get("type").toString() + " " + deployedArtifact.get("name").toString() + " to deployed artifacts queue."));
            deployedArtifacts.add((JsonElement)deployedArtifact);
        }
    }

    public static void addToUndeployedArtifactsQueue(JsonObject undeployedArtifact) {
        if (HeartBeatComponent.isDashboardConfigured()) {
            log.debug((Object)("Adding " + undeployedArtifact.get("type").toString() + " " + undeployedArtifact.get("name").toString() + " to undeployed artifacts queue."));
            undeployedArtifacts.add((JsonElement)undeployedArtifact);
        }
    }

    public static JsonArray getDeployedArtifacts() {
        return deployedArtifacts;
    }

    public static JsonArray getUndeployedArtifacts() {
        return undeployedArtifacts;
    }

    public static void removeFromDeployedArtifactsQueue(int artifactsSize) {
        for (int i = 0; i < artifactsSize; ++i) {
            deployedArtifacts.remove(0);
        }
    }

    public static void removeFromUndeployedArtifactsQueue(int artifactsSize) {
        for (int i = 0; i < artifactsSize; ++i) {
            undeployedArtifacts.remove(0);
        }
    }
}

