/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.dashboard;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.wso2.carbon.inbound.endpoint.internal.http.api.ConfigurationLoader;
import org.wso2.config.mapper.ConfigParser;
import org.wso2.micro.core.util.StringUtils;
import org.wso2.micro.integrator.initializer.dashboard.ArtifactDeploymentListener;
import org.wso2.micro.integrator.initializer.dashboard.ArtifactUpdateListener;

public class HeartBeatComponent {
    private static final Log log = LogFactory.getLog(HeartBeatComponent.class);
    private static final Map<String, Object> configs = ConfigParser.getParsedConfigs();
    private static final String CHANGE_NOTIFICATION = "changeNotification";
    private static final String DEPLOYED_ARTIFACTS = "deployedArtifacts";
    private static final String UNDEPLOYED_ARTIFACTS = "undeployedArtifacts";
    private static final String STATE_CHANGED_ARTIFACTS = "stateChangedArtifacts";

    private HeartBeatComponent() {
    }

    public static void invokeHeartbeatExecutorService() {
        String heartbeatApiUrl = configs.get("dashboard_config.dashboard_url") + "/heartbeat";
        String groupId = HeartBeatComponent.getGroupId();
        String nodeId = HeartBeatComponent.getNodeId();
        long interval = HeartBeatComponent.getInterval();
        String mgtApiUrl = HeartBeatComponent.getMgtApiUrl();
        HttpPost httpPost = new HttpPost(heartbeatApiUrl);
        JsonObject heartbeatPayload = new JsonObject();
        heartbeatPayload.addProperty("product", "mi");
        heartbeatPayload.addProperty("groupId", groupId);
        heartbeatPayload.addProperty("nodeId", nodeId);
        heartbeatPayload.addProperty("interval", (Number)interval);
        heartbeatPayload.addProperty("mgtApiUrl", mgtApiUrl);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Runnable runnableTask = () -> {
            JsonObject changeNotification = HeartBeatComponent.createChangeNotification();
            heartbeatPayload.add(CHANGE_NOTIFICATION, (JsonElement)changeNotification);
            try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();){
                StringEntity entity = new StringEntity(heartbeatPayload.toString());
                httpPost.setEntity((HttpEntity)entity);
                CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
                JsonObject jsonResponse = HeartBeatComponent.getJsonResponse(response);
                if (jsonResponse.get("status").getAsString().equals("success")) {
                    int deployedArtifactsCount = heartbeatPayload.get(CHANGE_NOTIFICATION).getAsJsonObject().get(DEPLOYED_ARTIFACTS).getAsJsonArray().size();
                    int undeployedArtifactsCount = heartbeatPayload.get(CHANGE_NOTIFICATION).getAsJsonObject().get(UNDEPLOYED_ARTIFACTS).getAsJsonArray().size();
                    int updatedArtifactsCount = heartbeatPayload.get(CHANGE_NOTIFICATION).getAsJsonObject().get(STATE_CHANGED_ARTIFACTS).getAsJsonArray().size();
                    ArtifactDeploymentListener.removeFromUndeployedArtifactsQueue(undeployedArtifactsCount);
                    ArtifactDeploymentListener.removeFromDeployedArtifactsQueue(deployedArtifactsCount);
                    ArtifactUpdateListener.removeFromUpdatedArtifactQueue(updatedArtifactsCount);
                }
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                log.debug((Object)"Error occurred while sending heartbeat request to dashboard.");
            }
        };
        scheduledExecutorService.scheduleAtFixedRate(runnableTask, 1L, interval, TimeUnit.SECONDS);
    }

    private static String getMgtApiUrl() {
        String serviceIp = System.getProperty("carbon.local.ip");
        String httpApiPort = Integer.toString(ConfigurationLoader.getInternalInboundHttpsPort());
        String mgtApiUrl = "https://".concat(serviceIp).concat(":").concat(httpApiPort).concat("/").concat("management").concat("/");
        Object mgtApiServiceName = configs.get("dashboard_config.management_hostname");
        if (null != mgtApiServiceName) {
            serviceIp = mgtApiServiceName.toString();
            Object configuredMgtPort = configs.get("dashboard_config.management_port");
            if (null != configuredMgtPort) {
                String servicePort = configuredMgtPort.toString();
                mgtApiUrl = "https://".concat(serviceIp).concat(":").concat(servicePort).concat("/").concat("management").concat("/");
            } else {
                mgtApiUrl = "https://".concat(serviceIp).concat("/").concat("management").concat("/");
            }
        }
        return mgtApiUrl;
    }

    private static String getGroupId() {
        Object id = configs.get("dashboard_config.group_id");
        String groupId = null != id ? id.toString() : "default";
        return groupId;
    }

    private static String getNodeId() {
        String nodeId = System.getProperty("node.id");
        if (StringUtils.isEmpty((String)nodeId)) {
            Object id = configs.get("dashboard_config.node_id");
            nodeId = null != id ? id.toString() : HeartBeatComponent.generateRandomId();
        }
        return nodeId;
    }

    private static long getInterval() {
        long interval = 5L;
        Object configuredInterval = configs.get("dashboard_config.heartbeat_interval");
        if (null != configuredInterval) {
            interval = Integer.parseInt(configuredInterval.toString());
        }
        return interval;
    }

    private static String generateRandomId() {
        return UUID.randomUUID().toString();
    }

    private static JsonObject createChangeNotification() {
        JsonObject changeNotification = new JsonObject();
        JsonArray deployedArtifacts = ArtifactDeploymentListener.getDeployedArtifacts();
        JsonArray undeployedArtifacts = ArtifactDeploymentListener.getUndeployedArtifacts();
        JsonArray stateChangedArtifacts = ArtifactUpdateListener.getStateChangedArtifacts();
        changeNotification.add(DEPLOYED_ARTIFACTS, (JsonElement)deployedArtifacts);
        changeNotification.add(UNDEPLOYED_ARTIFACTS, (JsonElement)undeployedArtifacts);
        changeNotification.add(STATE_CHANGED_ARTIFACTS, (JsonElement)stateChangedArtifacts);
        return changeNotification;
    }

    public static boolean isDashboardConfigured() {
        return configs.get("dashboard_config.dashboard_url") != null;
    }

    public static JsonObject getJsonResponse(CloseableHttpResponse response) {
        String stringResponse = HeartBeatComponent.getStringResponse(response);
        return new JsonParser().parse(stringResponse).getAsJsonObject();
    }

    public static String getStringResponse(CloseableHttpResponse response) {
        HttpEntity entity = response.getEntity();
        String stringResponse = "";
        try {
            stringResponse = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while converting entity to string.", (Throwable)e);
        }
        return stringResponse;
    }
}

