/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.deployment.application.deployer;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.micro.application.deployer.AppDeployerUtils;
import org.wso2.micro.application.deployer.CarbonApplication;
import org.wso2.micro.application.deployer.config.ApplicationConfiguration;
import org.wso2.micro.application.deployer.config.Artifact;
import org.wso2.micro.application.deployer.config.CappFile;
import org.wso2.micro.application.deployer.handler.AppDeploymentHandler;
import org.wso2.micro.core.CarbonAxisConfigurator;
import org.wso2.micro.core.util.CarbonException;
import org.wso2.micro.core.util.FileManipulator;
import org.wso2.micro.integrator.initializer.dashboard.ArtifactDeploymentListener;
import org.wso2.micro.integrator.initializer.serviceCatalog.ServiceCatalogDeployer;
import org.wso2.micro.integrator.initializer.utils.DeployerUtil;
import org.wso2.micro.integrator.initializer.utils.ServiceCatalogUtils;

public class CappDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(CappDeployer.class);
    private AxisConfiguration axisConfig;
    private List<AppDeploymentHandler> appDeploymentHandlers = new ArrayList<AppDeploymentHandler>();
    private static ArrayList<CarbonApplication> cAppMap = new ArrayList();
    private static ArrayList<CarbonApplication> faultyCAppObjects = new ArrayList();
    private static ArrayList<String> faultyCapps = new ArrayList();
    private final Object lock = new Object();
    private static final String SWAGGER_SUBSTRING = "_swagger";
    private static final String METADATA_FOLDER_NAME = "metadata";
    private static final String ARTIFACT_FILE = "artifact.xml";
    private String cAppDir;
    private String extension;
    private ExecutorService serviceCatalogExecutor;
    private Map serviceCatalogConfiguration;
    private SecretCallbackHandlerService secretCallbackHandlerService;

    public void init(ConfigurationContext configurationContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Capp Deployer..");
        }
        this.axisConfig = configurationContext.getAxisConfiguration();
        String appUnzipDir = AppDeployerUtils.getAppUnzipDir() + File.separator + AppDeployerUtils.getTenantIdString();
        FileManipulator.deleteDir((String)appUnzipDir);
        if (ServiceCatalogUtils.isServiceCatalogEnabled()) {
            this.serviceCatalogConfiguration = ServiceCatalogUtils.readConfiguration(this.secretCallbackHandlerService);
            this.serviceCatalogExecutor = Executors.newFixedThreadPool(ServiceCatalogUtils.getExecutorThreadCount(this.serviceCatalogConfiguration, 10));
        }
    }

    public void setDirectory(String cAppDir) {
        this.cAppDir = cAppDir;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String artifactPath = deploymentFileData.getAbsolutePath();
        try {
            this.deployCarbonApps(artifactPath);
        }
        catch (Exception e) {
            log.error((Object)("Error while deploying carbon application " + artifactPath), (Throwable)e);
        }
        super.deploy(deploymentFileData);
    }

    private void deployCarbonApps(String artifactPath) throws CarbonException {
        File cAppDirectory = new File(this.cAppDir);
        String archPathToProcess = AppDeployerUtils.formatPath((String)artifactPath);
        String cAppName = archPathToProcess.substring(archPathToProcess.lastIndexOf(47) + 1);
        if (!this.isCAppArchiveFile(cAppName)) {
            log.warn((Object)("Only .car files are processed. Hence " + cAppName + " will be ignored"));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Carbon Application detected : " + cAppName));
        }
        String targetCAppPath = cAppDirectory + File.separator + cAppName;
        CarbonApplication currentApp = null;
        try {
            currentApp = this.buildCarbonApplication(targetCAppPath, cAppName, this.axisConfig);
            if (currentApp != null) {
                this.searchArtifacts(currentApp.getExtractedPath(), currentApp);
                if (this.isArtifactReadyToDeploy(currentApp.getAppConfig().getApplicationArtifact())) {
                    for (AppDeploymentHandler appDeploymentHandler : this.appDeploymentHandlers) {
                        appDeploymentHandler.deployArtifacts(currentApp, this.axisConfig);
                    }
                } else {
                    log.error((Object)("Some dependencies were not satisfied in cApp:" + currentApp.getAppNameWithVersion() + "Check whether all dependent artifacts are included in cApp file: " + targetCAppPath));
                    this.deleteExtractedCApp(currentApp.getExtractedPath());
                    SynapseConfigUtils.getSynapseConfiguration((String)"carbon.super").validateSwaggerTable();
                    return;
                }
                currentApp.setDeploymentCompleted(true);
                this.addCarbonApp(currentApp);
                log.info((Object)("Successfully Deployed Carbon Application : " + currentApp.getAppNameWithVersion() + AppDeployerUtils.getTenantIdLogString((int)AppDeployerUtils.getTenantId())));
                for (Artifact.Dependency dependency : currentApp.getAppConfig().getApplicationArtifact().getDependencies()) {
                    if (!dependency.getServerRole().equals("DataServicesServer")) continue;
                    JsonObject deployedDataService = this.createUpdatedDataServiceInfoObject(dependency);
                    ArtifactDeploymentListener.addToDeployedArtifactsQueue(deployedDataService);
                }
                JsonObject deployedCarbonApp = this.createUpdatedCappInfoObject(currentApp);
                ArtifactDeploymentListener.addToDeployedArtifactsQueue(deployedCarbonApp);
            }
        }
        catch (DeploymentException e) {
            log.error((Object)("Error occurred while deploying the Carbon application: " + cAppName + ". Reverting successfully deployed artifacts in the CApp."), (Throwable)e);
            this.undeployCarbonApp(currentApp, this.axisConfig);
            SynapseConfigUtils.getSynapseConfiguration((String)"carbon.super").validateSwaggerTable();
            faultyCAppObjects.add(currentApp);
            faultyCapps.add(cAppName);
        }
        if (this.serviceCatalogConfiguration != null && !faultyCapps.contains(cAppName)) {
            ServiceCatalogDeployer serviceDeployer = new ServiceCatalogDeployer(cAppName, ((CarbonAxisConfigurator)this.axisConfig.getAxisConfiguration().getConfigurator()).getRepoLocation(), this.serviceCatalogConfiguration);
            this.serviceCatalogExecutor.execute(serviceDeployer);
        }
    }

    private CarbonApplication buildCarbonApplication(String targetCAppPath, String cAppName, AxisConfiguration axisConfig) throws CarbonException {
        String tempExtractedDirPath = AppDeployerUtils.extractCarbonApp((String)targetCAppPath);
        ApplicationConfiguration appConfig = new ApplicationConfiguration(tempExtractedDirPath);
        if (appConfig.getApplicationArtifact().getDependencies().isEmpty()) {
            log.warn((Object)("No artifacts found to be deployed in this server. Ignoring Carbon Application : " + cAppName));
            return null;
        }
        CarbonApplication carbonApplication = new CarbonApplication();
        carbonApplication.setAppFilePath(targetCAppPath);
        carbonApplication.setExtractedPath(tempExtractedDirPath);
        carbonApplication.setAppConfig(appConfig);
        String appName = appConfig.getAppName();
        if (appName == null) {
            log.warn((Object)("No application name found in Carbon Application : " + cAppName + ". Using the file name as the application name"));
            appName = cAppName.substring(0, cAppName.lastIndexOf(46));
        }
        if (this.appExists(appConfig.getAppNameWithVersion(), axisConfig)) {
            String msg = "Carbon Application : " + appConfig.getAppNameWithVersion() + " already exists. Two applications can't have the same Id. Deployment aborted.";
            log.error((Object)msg);
            throw new CarbonException(msg);
        }
        carbonApplication.setAppName(appName);
        String appVersion = appConfig.getAppVersion();
        if (appVersion != null && !"".equals(appVersion)) {
            carbonApplication.setAppVersion(appVersion);
        }
        return carbonApplication;
    }

    private boolean appExists(String newAppNameWithVersion, AxisConfiguration axisConfig) {
        CarbonApplication appToRemove = null;
        for (CarbonApplication carbonApp : CappDeployer.getCarbonApps()) {
            if (!newAppNameWithVersion.equals(carbonApp.getAppNameWithVersion())) continue;
            if (carbonApp.isDeploymentCompleted()) {
                return true;
            }
            appToRemove = carbonApp;
            break;
        }
        if (appToRemove != null) {
            this.undeployCarbonApp(appToRemove, axisConfig);
        }
        return false;
    }

    private void deleteExtractedCApp(String path) {
        try {
            FileUtils.deleteDirectory((File)new File(path));
        }
        catch (IOException e) {
            log.warn((Object)("Unable to locate: " + path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCarbonApp(CarbonApplication carbonApp) {
        Object object = this.lock;
        synchronized (object) {
            cAppMap.add(carbonApp);
        }
    }

    public static List<CarbonApplication> getCarbonApps() {
        return Collections.unmodifiableList(cAppMap);
    }

    private boolean isCAppArchiveFile(String filename) {
        return filename.endsWith(".car");
    }

    public synchronized void registerDeploymentHandler(AppDeploymentHandler handler) {
        this.appDeploymentHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchArtifacts(String rootDirPath, CarbonApplication parentApp) throws CarbonException {
        SynapseConfiguration synapseConfiguration = SynapseConfigUtils.getSynapseConfiguration((String)"carbon.super");
        HashMap<String, String> swaggerTable = new HashMap<String, String>();
        HashMap<String, String> apiArtifactMap = new HashMap<String, String>();
        File extractedDir = new File(rootDirPath);
        File[] allFiles = extractedDir.listFiles();
        if (allFiles == null) {
            return;
        }
        ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>();
        for (File artifactDirectory : allFiles) {
            if (!artifactDirectory.isDirectory()) continue;
            String directoryPath = AppDeployerUtils.formatPath((String)artifactDirectory.getAbsolutePath());
            String artifactXmlPath = directoryPath + File.separator + ARTIFACT_FILE;
            File f = new File(artifactXmlPath);
            if (!f.exists()) {
                File[] metadataFiles;
                if (!directoryPath.endsWith(METADATA_FOLDER_NAME)) continue;
                for (File metaFile : metadataFiles = new File(directoryPath).listFiles()) {
                    if (!metaFile.isDirectory()) continue;
                    try {
                        FileInputStream xmlInputStream = new FileInputStream(new File(metaFile, ARTIFACT_FILE));
                        Artifact artifact = this.buildAppArtifact(parentApp, xmlInputStream);
                        Artifact parentArtifact = parentApp.getAppConfig().getApplicationArtifact();
                        boolean removed = parentArtifact.getDependencies().removeIf(c -> c.getName().equals(artifact.getName()));
                        if (removed) {
                            --parentArtifact.unresolvedDepCount;
                        }
                        if (!metaFile.getName().contains(SWAGGER_SUBSTRING)) continue;
                        File swaggerFile = new File(metaFile, ((CappFile)artifact.getFiles().get(0)).getName());
                        byte[] bytes = Files.readAllBytes(Paths.get(swaggerFile.getPath(), new String[0]));
                        String artifactName = artifact.getName().substring(0, artifact.getName().indexOf(SWAGGER_SUBSTRING));
                        swaggerTable.put(artifactName, new String(bytes));
                    }
                    catch (FileNotFoundException e) {
                        log.error((Object)"Could not find the Artifact.xml file for the metadata", (Throwable)e);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error occurred while reading the swagger file from metadata", (Throwable)e);
                    }
                }
                continue;
            }
            Artifact artifact = null;
            FileInputStream xmlInputStream = null;
            try {
                String apiXmlPath;
                String apiName;
                xmlInputStream = new FileInputStream(f);
                artifact = this.buildAppArtifact(parentApp, xmlInputStream);
                if (artifact.getType().equals("synapse/api") && !StringUtils.isEmpty((String)(apiName = this.getApiNameFromFile(new FileInputStream(apiXmlPath = directoryPath + File.separator + ((CappFile)artifact.getFiles().get(0)).getName()))))) {
                    apiArtifactMap.put(artifact.getName(), apiName);
                }
            }
            catch (FileNotFoundException e) {
                this.handleException("artifacts.xml File cannot be loaded from " + artifactXmlPath, e);
            }
            finally {
                if (xmlInputStream != null) {
                    try {
                        ((InputStream)xmlInputStream).close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while closing input stream.", (Throwable)e);
                    }
                }
            }
            if (artifact == null) {
                return;
            }
            artifact.setExtractedPath(directoryPath);
            allArtifacts.add(artifact);
        }
        Artifact appArtifact = parentApp.getAppConfig().getApplicationArtifact();
        this.buildDependencyTree(appArtifact, allArtifacts);
        for (String artifactName : swaggerTable.keySet()) {
            String apiname = (String)apiArtifactMap.get(artifactName);
            if (StringUtils.isEmpty((String)apiname)) continue;
            synapseConfiguration.addSwaggerDefinition(apiname, (String)swaggerTable.get(artifactName));
        }
    }

    private Artifact buildAppArtifact(CarbonApplication parentApp, InputStream artifactXmlStream) throws CarbonException {
        Artifact artifact = null;
        try {
            OMElement artElement = new StAXOMBuilder(artifactXmlStream).getDocumentElement();
            if (!"artifact".equals(artElement.getLocalName())) {
                log.error((Object)("artifact.xml is invalid. Parent Application : " + parentApp.getAppNameWithVersion()));
                return null;
            }
            artifact = AppDeployerUtils.populateArtifact((OMElement)artElement);
        }
        catch (XMLStreamException e) {
            this.handleException("Error while parsing the artifact.xml file ", e);
        }
        if (artifact == null || artifact.getName() == null) {
            log.error((Object)("Invalid artifact found in Carbon Application : " + parentApp.getAppNameWithVersion()));
            return null;
        }
        return artifact;
    }

    private boolean isArtifactReadyToDeploy(Artifact rootArtifact) {
        if (rootArtifact == null) {
            return false;
        }
        boolean isReady = true;
        for (Artifact.Dependency dep : rootArtifact.getDependencies()) {
            isReady = this.isArtifactReadyToDeploy(dep.getArtifact());
            if (isReady) continue;
            return false;
        }
        if (rootArtifact.unresolvedDepCount > 0) {
            isReady = false;
        }
        return isReady;
    }

    private void buildDependencyTree(Artifact rootArtifact, List<Artifact> allArtifacts) {
        for (Artifact.Dependency dep : rootArtifact.getDependencies()) {
            for (Artifact temp : allArtifacts) {
                if (!dep.getName().equals(temp.getName())) continue;
                String depVersion = dep.getVersion();
                String attVersion = temp.getVersion();
                if ((depVersion != null || attVersion != null) && (depVersion == null || !depVersion.equals(attVersion))) continue;
                dep.setArtifact(temp);
                --rootArtifact.unresolvedDepCount;
                break;
            }
            if (dep.getArtifact() == null) continue;
            this.buildDependencyTree(dep.getArtifact(), allArtifacts);
        }
    }

    private void handleException(String msg, Exception e) throws CarbonException {
        log.error((Object)msg, (Throwable)e);
        throw new CarbonException(msg, (Throwable)e);
    }

    public void undeploy(String filePath) throws DeploymentException {
        CarbonApplication existingApp = null;
        for (CarbonApplication carbonApp : CappDeployer.getCarbonApps()) {
            if (!filePath.equals(carbonApp.getAppFilePath())) continue;
            existingApp = carbonApp;
            break;
        }
        if (existingApp != null) {
            this.undeployCarbonApp(existingApp, this.axisConfig);
        } else {
            log.info((Object)("Undeploying Faulty Carbon Application On : " + filePath));
            this.removeFaultyCarbonApp(filePath);
        }
        super.undeploy(filePath);
    }

    private void undeployCarbonApp(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        log.info((Object)("Undeploying Carbon Application : " + carbonApp.getAppNameWithVersion() + "..."));
        try {
            for (int handlerIndex = this.appDeploymentHandlers.size() - 1; handlerIndex >= 0; --handlerIndex) {
                AppDeploymentHandler handler = this.appDeploymentHandlers.get(handlerIndex);
                handler.undeployArtifacts(carbonApp, axisConfig);
            }
            this.removeCarbonApp(carbonApp);
            FileManipulator.deleteDir((String)carbonApp.getExtractedPath());
            log.info((Object)("Successfully undeployed Carbon Application : " + carbonApp.getAppNameWithVersion() + AppDeployerUtils.getTenantIdLogString((int)AppDeployerUtils.getTenantId())));
            for (Artifact.Dependency dependency : carbonApp.getAppConfig().getApplicationArtifact().getDependencies()) {
                if (!dependency.getServerRole().equals("DataServicesServer")) continue;
                JsonObject undeployedDataService = this.createUpdatedDataServiceInfoObject(dependency);
                ArtifactDeploymentListener.addToUndeployedArtifactsQueue(undeployedDataService);
            }
            JsonObject undeployedCarbonApp = this.createUpdatedCappInfoObject(carbonApp);
            ArtifactDeploymentListener.addToUndeployedArtifactsQueue(undeployedCarbonApp);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while trying to unDeploy  : " + carbonApp.getAppNameWithVersion()), (Throwable)e);
        }
    }

    private JsonObject createUpdatedCappInfoObject(CarbonApplication capp) {
        JsonObject cappInfo = new JsonObject();
        cappInfo.addProperty("type", "applications");
        cappInfo.addProperty("name", capp.getAppName());
        cappInfo.addProperty("version", capp.getAppVersion());
        return cappInfo;
    }

    private JsonObject createUpdatedDataServiceInfoObject(Artifact.Dependency dataService) {
        JsonObject dataServiceInfo = new JsonObject();
        dataServiceInfo.addProperty("type", "data-services");
        dataServiceInfo.addProperty("name", dataService.getName());
        dataServiceInfo.addProperty("version", dataService.getVersion());
        return dataServiceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCarbonApp(CarbonApplication carbonApp) {
        Object object = this.lock;
        synchronized (object) {
            cAppMap.remove(carbonApp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFaultyCarbonApp(String appFilePath) {
        Object object = this.lock;
        synchronized (object) {
            String cAppName = appFilePath.substring(appFilePath.lastIndexOf(File.separator) + 1);
            faultyCapps.remove(cAppName);
            for (CarbonApplication application : faultyCAppObjects) {
                if (!application.getAppFilePath().equals(appFilePath)) continue;
                faultyCAppObjects.remove(application);
                break;
            }
        }
    }

    public static List<String> getFaultyCapps() {
        return Collections.unmodifiableList(faultyCapps);
    }

    public static List<CarbonApplication> getFaultyCAppObjects() {
        return Collections.unmodifiableList(faultyCAppObjects);
    }

    public void cleanup() {
        cAppMap.clear();
        faultyCapps.clear();
        faultyCAppObjects.clear();
    }

    public void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        this.secretCallbackHandlerService = secretCallbackHandlerService;
    }

    private String getApiNameFromFile(InputStream apiXmlStream) {
        try {
            OMElement apiElement = new StAXOMBuilder(apiXmlStream).getDocumentElement();
            API api = DeployerUtil.partiallyBuildAPI(apiElement);
            return api.getName();
        }
        catch (XMLStreamException | OMException e) {
            return null;
        }
    }
}

