/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.deployment.artifact.deployer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArtifactDeploymentManager {
    private static final Log log = LogFactory.getLog(ArtifactDeploymentManager.class);
    private AxisConfiguration axisConfiguration;
    private HashMap<String, Deployer> dirToDeployerMap;

    public ArtifactDeploymentManager(AxisConfiguration axisConfiguration) {
        this.axisConfiguration = axisConfiguration;
        this.dirToDeployerMap = new HashMap();
    }

    public void deploy() {
        Set<Map.Entry<String, Deployer>> deploymentEntries = this.dirToDeployerMap.entrySet();
        for (Map.Entry<String, Deployer> deployerEntry : deploymentEntries) {
            File confDirFile;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deploying artifacts from: " + deployerEntry.getKey()));
            }
            if (!(confDirFile = new File(deployerEntry.getKey())).isDirectory() || !confDirFile.exists()) continue;
            File[] configFiles = confDirFile.listFiles();
            if (configFiles == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No configurations found to deploy in: " + deployerEntry.getKey()));
                continue;
            }
            for (File configFile : configFiles) {
                if (!configFile.isFile()) continue;
                try {
                    deployerEntry.getValue().deploy(new DeploymentFileData(configFile, deployerEntry.getValue()));
                }
                catch (DeploymentException e) {
                    log.error((Object)("Error occurred while deploying : " + configFile.getName()), (Throwable)e);
                }
            }
        }
    }

    public void registerDeployer(String directoryPath, Deployer deployer) throws DeploymentException {
        if (deployer == null) {
            throw new DeploymentException("Registering null deployer for target directory: " + directoryPath);
        }
        this.dirToDeployerMap.put(directoryPath, deployer);
    }
}

